/***************************************************************************
 $RCSfile: delstandingorder.cpp,v $
                             -------------------
    cvs         : $Id: delstandingorder.cpp,v 1.7 2003/05/18 03:02:12 aquamaniac Exp $
    begin       : Thu Jul 11 2002
    copyright   : (C) 2002 by Fabian Kaiser
    email       : openhbci@derzach.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
# include <config.h>
#endif


/*
 */

#include "delstandingorder.h"


HBCI::Error delStandingOrder(HBCI::Pointer<AQMAPI> hbciif,
			     HBCI::SimpleConfig &opt){
    HBCI::Pointer<HBCI::OutboxJob> job;
    HBCI::Tree<HBCI::ConfigNode>::iterator var;
    int country;
    string instid;
    string custid;
    string accnr;
    string tfile;
    HBCI::Pointer<HBCI::Loader> loader;
    list<HBCI::Pointer<HBCI::Account> > accounts;
    list<HBCI::StandingOrder> orders;
    list<HBCI::StandingOrder>::iterator oit;
    HBCI::Pointer<HBCI::Account> account;
    HBCI::Error err, err1;
    HBCI::Pointer<HBCI::User> customer;
    HBCI::Pointer<HBCI::Customer> cust;

    account.setDescription("delStandingOrder::account");
    loader.setDescription("delStandingOrder::loader");
    loader=new HBCI::Loader(hbciif.ptr());
    custid=opt.getVariable("customer","",opt.root());
    job.setDescription("delStandingOrder:job (HBCI::OutboxJob)");

    tfile=opt.getVariable("tfile","",opt.root());
	
    // load the transaction file
    err1=loader.ref().readStandingOrderFile(tfile, orders);
    if (!err1.isOk())
        return err1;

    // create jobs
    for (oit=orders.begin();
	 oit!=orders.end();
	 oit++) {

      // get account
      country = (*oit).ourCountryCode();
      instid = (*oit).ourBankCode();
      accnr = (*oit).ourAccountId();

      if (0 == country)
	country = 280;
      account = hbciif.ref().findAccount(country, instid, accnr);
      if (!account.isValid()) {
	return HBCI::Error("delstdorder()",
			   ERROR_LEVEL_NORMAL,
			   0,
			   ERROR_ADVISE_DONTKNOW,
			   "account not found");
      }

      // get authorized customer for this account
      if (!custid.empty()) {
	// customer given
	cust=account.ref().bank().ref().findCustomer(custid);
	if (!cust.isValid())
	  return HBCI::Error("delstandingorders()",
			     ERROR_LEVEL_NORMAL,
			     0,
			     ERROR_ADVISE_DONTKNOW,
			     "customer not found");
	if (!(account.ref().isAuthorized(cust)))
	  return HBCI::Error("delstandingorders()",
			     ERROR_LEVEL_NORMAL,
			     0,
			     ERROR_ADVISE_DONTKNOW,
			     "customer is not authorized");
      }
      else {
	// not given, try the first in the list
	list<HBCI::Pointer<HBCI::Customer> > custlist;

	custlist=account.ref().authorizedCustomers();
	if (custlist.empty())
	  return HBCI::Error("delstandingorders()",
			     ERROR_LEVEL_NORMAL,
			     0,
			     ERROR_ADVISE_DONTKNOW,
			     "no authorized customer for this account");
	cust=custlist.front();
      }


      // create job for this account
      if (!HBCI::OutboxJobDeleteStandingOrder::deletionTerminable(account.ref().bank().ref())) {
	(*oit).setExecutionDate(HBCI::Date());
      }
      job=new HBCI::OutboxJobDeleteStandingOrder(cust,account, (*oit));

      // enqueue job
      hbciif.ref().addJob(job);
    } // for

    try {
      // execute queue
      err=hbciif.ref().executeQueue(true);
    }
    catch (HBCI::Error lerr) {
      err=lerr;
    }

    return err;
}


