#ifndef JUMPER_H
#define JUMPER_H
struct object;
#ifdef  JUMPER_C
#include <string.h>
#include "hill.h"
#include "frame.h"
#include "slangwrap.h"
#include "xfnc.h"
#include "skin.h"

#define PREV_GRASP (-001)
#define NEXT_GRASP (-002)
#define NEXT_FRAME (-003)

static int jumper_animate(struct object *jumper, int state);
static void jumper_service_telemark(struct object *jumper);
static void jumper_service_jump(struct object *jumper);
static void jumper_service_lucky(struct object *jumper);
static void jumper_service_move(struct object *jumper);
static void jumper_setpoints(struct object *jumper);
#endif
struct object {
	struct object *next;
	int x, y;
	double vx, vy, px, py;

	int bend, state;
	double alight, points, last_points, judge[5];
	
	struct frame *current_frame;
	struct hill *current_hill;
	int current_x, current_y;
	int color, color2;
	int in_use, new_owner;

	char *name;
	int level;
};

void object_draw(struct object *o);
void jumper_draw(struct object *o);
int jumper_service(struct object *jumper, int key);
struct object* object_init(int color, int cx, int cy);
void jumper_flush(struct object *jumper, struct hill *m);
void jumper_change_mode(struct object *jumper, char *name, 
	int color, int level, int in_use);
struct object* jumper_init(struct hill *m, struct frame *f, char *name);
void jumper_tabsort(struct object **tab, int len);
void jumper_cpujump(struct object *jumper);

#endif
