/****************************************************************
**
** Attal : Lords of Doom
**
** itemSelector.cpp
** Allow selection of item panels
**
** Version : $Id: itemSelector.cpp,v 1.7 2004/12/18 12:18:53 audoux Exp $
**
** Author(s) : Pascal Audoux
**
** Date : 21/12/2001
**
** Licence :    
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

#include "itemSelector.h"
 
// generic include files
// include files for QT
#include <qcombobox.h>
#include <qwidgetstack.h>
#include <qlayout.h>
// application specific include files
#include "scenarioEditor/itemSelection.h"
#include "scenarioEditor/screen.h"
#include "scenarioEditor/tileSelection.h"
#include "libClient/gui.h"
#include "libClient/cell.h"

#include "libServer/gameData.h"


ItemSelector::ItemSelector( GameData * data, Screen * screen, const char * name )
	:QWidget( screen, name )
{
	_data = data;
	_screen = screen;

	QVBoxLayout * layout = new QVBoxLayout( this );
	layout->setMargin( 5 );
	layout->setSpacing( 5 );

	_selector = new QComboBox( this );
	_selector->setFixedHeight( _selector->sizeHint().height() );
	layout->addWidget( _selector );

	_stack = new QWidgetStack( this );
	layout->addWidget( _stack, 1 );

	layout->activate();
	
	init();
	
	connect( _selector, SIGNAL( activated( int ) ), _stack, SLOT( raiseWidget( int ) ) );
	setFixedWidth( 235 );
}

void ItemSelector::init()
{
	_selector->insertItem( QObject::tr( "Tile" ), ItemTile );
	_selector->insertItem( QObject::tr( "Transition" ), ItemTransition );
	_selector->insertItem( QObject::tr( "Decoration" ), ItemDecoration );
	_selector->insertItem( QObject::tr( "Building" ), ItemBuilding );
	_selector->insertItem( QObject::tr( "Base" ), ItemBase );
	_selector->insertItem( QObject::tr( "Lord" ), ItemLord );
	_selector->insertItem( QObject::tr( "Artefact" ), ItemArtefact );
	_selector->insertItem( QObject::tr( "Bonus" ), ItemBonus );
	_selector->insertItem( QObject::tr( "Creature" ), ItemCreature );
	_selector->insertItem( QObject::tr( "Tool" ), ItemTool );
	
	ItemScroll * view0 = new ItemScroll( this );
	TileSelection * wid0 = new TileSelection( view0->viewport() );
	view0->addItem( wid0 );
	_stack->addWidget( view0, ItemTile );
	wid0->setGameData( _data );

	ItemScroll * view1 = new ItemScroll( this );
	TransitionSelection * wid1 = new TransitionSelection( view1->viewport() );
	view1->addItem( wid1 );
	_stack->addWidget( view1, ItemTransition );
	wid1->setGameData( _data );

	ItemScroll * view2 = new ItemScroll( this );
	DecorationGroupSelection * wid2 = new DecorationGroupSelection( view2->viewport() );
	view2->addItem( wid2 );
	_stack->addWidget( view2, ItemDecoration );
	wid2->setGameData( _data );

	ItemScroll * view3 = new ItemScroll( this );
	BuildingSelection * wid3 = new BuildingSelection( view3->viewport() );
	view3->addItem( wid3 );
	_stack->addWidget( view3, ItemBuilding );
	wid3->setGameData( _data );

	ItemScroll * view4 = new ItemScroll( this );
	BaseSelection * wid4 = new BaseSelection( view4->viewport() );
	view4->addItem( wid4 );
	_stack->addWidget( view4, ItemBase );
	wid4->setGameData( _data );

	ItemScroll * view5 = new ItemScroll( this );
	LordSelection * wid5 = new LordSelection( view5->viewport() );
	view5->addItem( wid5 );
	_stack->addWidget( view5, ItemLord );
	wid5->setGameData( _data );

	ItemScroll * view6 = new ItemScroll( this );
	ArtefactSelection * wid6 = new ArtefactSelection( view6->viewport() );
	view6->addItem( wid6 );
	_stack->addWidget( view6, ItemArtefact );
	wid6->setGameData( _data );

	ItemScroll * view7 = new ItemScroll( this );
	BonusSelection * wid7 = new BonusSelection( view7->viewport() );
	view7->addItem( wid7 );
	_stack->addWidget( view7, ItemBonus );
	wid7->setGameData( _data );

	ItemScroll * view8 = new ItemScroll( this );
	CreatureSelection * wid8 = new CreatureSelection( view8->viewport() );
	view8->addItem( wid8 );
	_stack->addWidget( view8, ItemCreature );
	wid8->setGameData( _data );

	ItemScroll * view9 = new ItemScroll( this );
	ToolSelection * wid9 = new ToolSelection( _screen, view9->viewport() );
	view9->addItem( wid9 );
	_stack->addWidget( view9, ItemTool );
	wid9->setGameData( _data );

	_stack->raiseWidget( 0 );
}

void ItemSelector::handleLeftClick( Cell * cell )
{
	( (ItemScroll *)_stack->visibleWidget() )->handleLeftClick( cell );
}

//
// ----- ItemScroll -----
//

ItemScroll::ItemScroll( QWidget * parent )
	:QScrollView( parent )
{
	_item = 0;
	setBackgroundColor( lightGray );
	setVScrollBarMode( QScrollView::AlwaysOn );
	setHScrollBarMode( QScrollView::AlwaysOff );	
}

void ItemScroll::addItem( ItemSelection * item )
{
	_item = item;
	addChild( item );
}

void ItemScroll::handleLeftClick( Cell * c )
{
	if( _item ) {
		_item->handleLeftClick( c );
	}
}

