/****************************************************************
**
** Attal : Lords of Doom
**
** themeInterface.h
** Manages the theme editor
**
** Version : $Id: themeInterface.h,v 1.3 2004/01/10 21:35:17 audoux Exp $
**
** Author(s) : Pascal Audoux
**
** Date : 02/06/2001
**
** Licence :    
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

 
#ifndef THEMEINTERFACE_H
#define THEMEINTERFACE_H
 
// include files for QT
#include <qaction.h>
#include <qmainwindow.h>
#include <qptrvector.h>
#include <qstring.h>
// application specific include

class QPopupMenu;
class SectionSelector;


/*              ------------------------------
 *                         ThemeInterface
 *              ------------------------------ */


/** comment for the class */
class ThemeInterface : public QMainWindow
{
	Q_OBJECT
public:
	/** Constructor */
	ThemeInterface();
		
private:
	enum MENU_ACTIONS {
		ACTION_NEW,
		ACTION_OPEN,
		ACTION_SAVE,
		ACTION_QUIT,
		ACTION_HELP,

		NB_ACTIONS
	};

	/** Defines actions */
	void initActions();

	/** Defines menus */
	void initMenuBar();

	/** Defines statusBar */
	void initStatusBar();

public slots:
	/** Slot managing actions */
	void slot_actions( int num );

	/** Slot managing the status bar */
	void slot_status( QString text );
	
private:
	SectionSelector * _selector;
	QPtrVector<QAction> _actions;
};
 
#endif // THEMEINTERFACE_H   
