/*
 * Decompiled with CFR 0.152.
 */
package nz.net.catalyst.lucene.server;

import java.io.File;
import java.io.IOException;
import nz.net.catalyst.ELog;
import nz.net.catalyst.Log;
import nz.net.catalyst.lucene.server.Application;
import nz.net.catalyst.lucene.server.ApplicationMissingException;
import nz.net.catalyst.lucene.server.Constants;
import nz.net.catalyst.lucene.server.ECommand;
import nz.net.catalyst.lucene.server.IPackage;
import nz.net.catalyst.lucene.server.Transmission;
import nz.net.catalyst.lucene.server.WriterControl;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexWriter;

public class Optimize
implements IPackage,
Constants {
    private final Transmission input;
    private Application application;

    Optimize(Transmission transmission) {
        this.input = transmission;
    }

    Transmission execute() {
        long afterOptimize;
        long afterWriterOpen;
        long beforeOpen;
        Transmission response;
        block20: {
            long queryStart = System.currentTimeMillis();
            response = new Transmission(ECommand.CONTROL_RESPONSE);
            response.setSerial(this.input.getSerial());
            String appName = this.input.get("Application", Constants.NO_APP);
            try {
                this.application = Application.getAppOrDefault(appName);
            }
            catch (ApplicationMissingException e) {
                return this.error(e.getMessage());
            }
            this.input.setApplication(this.application);
            Analyzer analyzer = Application.getAnalyzer(this.input);
            File luceneStoreDir = Application.getIndexDirectory(this.application);
            WriterControl writerControl = null;
            beforeOpen = System.currentTimeMillis();
            boolean succeed = false;
            Log.log(ELog.DEBUG, "About to optimize index in: " + luceneStoreDir);
            try {
                try {
                    writerControl = WriterControl.getWriterControl(luceneStoreDir, analyzer);
                    IndexWriter writer = writerControl.getIndexWriter();
                    afterWriterOpen = System.currentTimeMillis();
                    writer.optimize();
                    afterOptimize = System.currentTimeMillis();
                    succeed = true;
                }
                catch (IOException e) {
                    Transmission transmission;
                    block17: {
                        String message = "Error while optimizing " + luceneStoreDir + ": " + e.toString();
                        Log.log(ELog.ERROR, message);
                        transmission = this.error(message);
                        Object var17_20 = null;
                        if (writerControl != null) {
                            try {
                                writerControl.release();
                            }
                            catch (Throwable e2) {
                                String message2 = "Error while closing IndexWriter: " + e2.toString();
                                Log.log(ELog.ERROR, message2);
                                if (!succeed) break block17;
                                return this.error(message2);
                            }
                        }
                    }
                    return transmission;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    Transmission transmission;
                    block18: {
                        String message = "Error while backing up (probable index corruption) " + luceneStoreDir + ": " + e.toString();
                        Log.log(ELog.ERROR, message);
                        transmission = this.error(message);
                        Object var17_21 = null;
                        if (writerControl != null) {
                            try {
                                writerControl.release();
                            }
                            catch (Throwable e2) {
                                String message2 = "Error while closing IndexWriter: " + e2.toString();
                                Log.log(ELog.ERROR, message2);
                                if (!succeed) break block18;
                                return this.error(message2);
                            }
                        }
                    }
                    return transmission;
                }
            }
            catch (Throwable throwable) {
                block19: {
                    Object var17_22 = null;
                    if (writerControl != null) {
                        try {
                            writerControl.release();
                        }
                        catch (Throwable e2) {
                            String message2 = "Error while closing IndexWriter: " + e2.toString();
                            Log.log(ELog.ERROR, message2);
                            if (!succeed) break block19;
                            return this.error(message2);
                        }
                    }
                }
                throw throwable;
            }
            Object var17_23 = null;
            if (writerControl != null) {
                try {
                    writerControl.release();
                }
                catch (Throwable e2) {
                    String message2 = "Error while closing IndexWriter: " + e2.toString();
                    Log.log(ELog.ERROR, message2);
                    if (!succeed) break block20;
                    return this.error(message2);
                }
            }
        }
        long afterWriterClose = System.currentTimeMillis();
        response.add("Open", String.valueOf(afterWriterOpen - beforeOpen));
        response.add("Optimize", String.valueOf(afterOptimize - afterWriterOpen));
        response.add("Close", String.valueOf(afterWriterClose - afterOptimize));
        return response;
    }

    private Transmission error(String message) {
        Transmission response = new Transmission(ECommand.CONTROL_RESPONSE);
        response.setSerial(this.input.getSerial());
        response.add("Error", message);
        return response;
    }
}

