/** *********************************************************************
 * Copyright (C) 2003 Catalyst IT                                       *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to:                           *
 *   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    *
 *   Boston, MA  02111-1307  USA                                        *
 ************************************************************************/
package nz.net.catalyst.lucene.server;

import nz.net.catalyst.Log;
import nz.net.catalyst.Main;

/**
 * Do a byte to character mapping for all bytes, then a reverse
 * character to byte mapping for characters 0 - 300
 */

public class CharSet extends Main implements IPackage
{
  private static final CharSet instance = new CharSet();

  /**
   * Read config file and start the system.
   */
  public static void main(String args[])
  {
    instance.init(args);
  }

  /**
   * Called by startup sequence.  Invoke a TCP Socket listener and
   * await connections.  Each connection will activate a new thread
   * under the control of a {@link Session} instance.
   *
   * @param args Command line parameters (currently ignored).
   */
  public static void Start(String[] args)
  {
    try
    {
      if (args.length == 0)
        args = new String[]{null};

      for (int arg = 0; arg < args.length; ++arg)
      {
        String set = args[arg];

        Log.debug("Conversion mapping for charset " +
                           (set == null ? "<default>" : set));


        for (int i = 0; i < 256; ++i)
        {
          byte b[] = new byte[]{(byte) i};
          String s = set == null ? new String(b) : new String(b, set);
          StringBuffer sb = new StringBuffer("Byte ");
          sb.append(Integer.toHexString((int) b[0] & 0xFF));
          sb.append(" -> Char");

          for (int c = 0; c < s.length(); ++c)
          {
            sb.append(' ');
            sb.append(Integer.toHexString((int)s.charAt(c)));
          }

          Log.debug(sb);
        }

        for (int i = 0; i <= 300; ++i)
        {
          char ch[] = new char[]{(char)i};
          String s = new String(ch);
          byte b[] = set == null ? s.getBytes() : s.getBytes(set);
          StringBuffer sb = new StringBuffer("Char ");
          sb.append(Integer.toHexString(i));
          sb.append(" -> Byte");

          for (int c = 0; c < b.length; ++c)
          {
            sb.append(' ');
            sb.append(Integer.toHexString((int)b[c] & 0xFF));
          }
          Log.debug(sb);
        }
      }
    }
    catch (Throwable t)
    {
      t.printStackTrace();
    }
  }
}
