/* arch-cache.h:
 *
 ****************************************************************
 * Copyright (C) 2004 Aaron Bentley
 *
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 */


#ifndef INCLUDE__LIBARCH__ARCH_CACHE_H
#define INCLUDE__LIBARCH__ARCH_CACHE_H

#include "hackerlab/char/str.h"
#include "libarch/patch-id.h"

extern int
arch_cache_active (void);

extern t_uchar * 
arch_cache_revision_path (t_uchar * fq_rvsn);

extern int 
arch_cache_has_answer (t_uchar * rel_query_path);

extern int 
arch_cache_maybe_get (t_uchar * rel_query_path);

extern int 
arch_cache_get (t_uchar * rel_query_path);

extern t_uchar *
arch_cache_get_str (t_uchar * rel_query_path);

extern t_uchar *
arch_cache_get_line (t_uchar * rel_query_path);

extern int 
arch_cache_put (t_uchar **tmp_name, t_uchar *rel_query_path);

extern void 
arch_cache_commit (t_uchar *tmp_name, t_uchar *rel_query_path);

extern void 
arch_cache_put_str (t_uchar * rel_query_path, t_uchar * answer);

extern void 
arch_cache_put_line (t_uchar * rel_query_path, t_uchar const * answer);

extern t_uchar *
arch_cache_query_new (arch_patch_id * patch_id, t_uchar const *extension);

#endif 

/* tag: 6157fb44-adc8-4ed1-8522-e5d54b9a29e6 */
