#!/bin/sh
# -*- mode: sh; coding: utf-8 -*-
# Simple switch tests
# Copyright © 2004 Canonical Ltd
#           Author: Robert Collins <robert.collins@canonical.com>
#
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.

set -e

arg0="$0"
srcdir=`dirname "$arg0"`

. ${srcdir}/test-framework

setup_with_trivial_archives

test_class "switch"

tla branch jane@example.com--2003/hello-world--mainline--1.0 foo@example.org--2003/hello-world--devo--1.3 1>/dev/null

setup_switch () {
  tla get jane@example.com--2003/hello-world--mainline--1.0 hello-world
  copy_tree hello-world hello-world.good
  cd hello-world
} 

begin_test "switch changes tree version"
setup_switch
tla switch foo@example.org--2003/hello-world--devo--1.3
[ "foo@example.org--2003/hello-world--devo--1.3" == $(tla tree-version) ]
end_test 

begin_test "switch changes tree for a revision"
setup_switch
tla switch foo@example.org--2003/hello-world--devo--1.3--base-0
[ "foo@example.org--2003/hello-world--devo--1.3" == $(tla tree-version) ]
end_test 

begin_test "switch with no changes has no changes in the new version"
setup_switch
tla switch foo@example.org--2003/hello-world--devo--1.3
tla diff
end_test 

begin_test "switch with changes preserves changes"
setup_switch
mv hello-world.c hello_world.c
tla move hello-world.c hello_world.c
tla switch foo@example.org--2003/hello-world--devo--1.3
tla diffs && test_fail "Move not preserved"
#should be changes.
end_test 

begin_test "switch with changes that conflict produces conflict"
tla get foo@example.org--2003/hello-world--devo--1.3 hello-world
cd hello-world
sed -e 's/Hello world/Hello, World/' < hello-world.c > hello-world.c.new
mv hello-world.c.new hello-world.c
tla commit -s 'add a comma'
cd ..
rm -rf hello-world
setup_switch
sed -e 's/Hello world/Hello, World/' < hello-world.c > hello-world.c.new
mv hello-world.c.new hello-world.c
tla switch foo@example.org--2003/hello-world--devo--1.3 && test_fail "conflict not indicated in switch return code"
if [ ! -e hello-world.c.rej ]; then
 test_fail "no conflict file was created."
fi
end_test 

begin_test "switch with changes that might conflict to an earlier revision doesn't conflict"
tla get foo@example.org--2003/hello-world--devo--1.3 hello-world
cd hello-world
sed -e 's/Hello world/Hello, World/' < hello-world.c > hello-world.c.new
mv hello-world.c.new hello-world.c
tla commit -s 'add a comma'
cd ..
rm -rf hello-world
setup_switch
sed -e 's/Hello world/Hello, World/' < hello-world.c > hello-world.c.new
mv hello-world.c.new hello-world.c
tla switch foo@example.org--2003/hello-world--devo--1.3--base-0
if [ -e hello-world.c.rej ]; then
 test_fail "conflict file was created."
fi
end_test 



clean_workdir
