 h2n(1)                                                               h2n(1)
                               August 21, 2000

 NAME
      h2n - Translate host table to name server file format

 SYNOPSIS
      h2n -d DOMAIN -n NET -u CONTACT [options]

 DESCRIPTION
      h2n translates /etc/hosts to DNS files and creates a BIND boot file.
      This tool can be run once or many times.  After converting your host
      table to DNS format, you can manually maintain the DNS files, or you
      can maintain the host table and run h2n each time you modify
      /etc/hosts.  h2n automatically increments the serial number in each
      DNS file when it makes a new one.

      h2n generates files starting with the prefix "db."  These are called
      "db files."  The domain data are stored in a file called db.DOMAIN,
      where DOMAIN defaults to the first label in your domain name (given
      with the -d option).  The address-to-name data are stored in files
      named db.NET, where NET is a network number (given with the -n
      option).  An email address for the person responsible for the domain
      is included in the start-of-authority record for the domain (given
      with the -u option).

      Each time h2n is run, it generates the DNS files from scratch.  Any
      changes you manually made to the DNS files are lost.  If you'd like to
      add resource records to a db file generated by h2n, put your RRs in a
      file prefixed with "spcl" instead of "db".  h2n will include this
      file's data by adding an $INCLUDE directive to the end of the db file.

      By default, h2n will generate an MX record with a weight of 10 that
      points to the host itself as the mail exchanger.  Additional MX
      records can be added to all hosts by using -m options.  To suppress
      generating the default MX record for a host, include "[no smtp]" in
      that host's host table comment.  Note that "[no smtp]" does not
      override -m options.  Use "[no mx]" in the comment field to suppress
      all MX record generation for that host.  This is useful for such IP
      devices as printers which do not need mailer information.  In
      conjunction with "[no mx]", you can add the "[smtp]" flag in the
      comment field to have only the default MX record added, suppressing -m
      options for the host.  All MX record generation for the domain can be
      suppressed with -M.

      Another comment section flag is "[TTL=num]", where num is a specific
      time-to-live value to use for the resource records pertaining to the
      canonical hostname in the host table.  This is useful for setting
      artificially high or low TTL values for individual hosts.  For
      example, if you are going to be moving a host to a new IP address, you
      can use this to set a low TTL value such as 900 (seconds).  This
      limits how long the old IP address will be cached everywhere.  The
      maximum any client will have to wait for the new IP address to be seen
      would be 15 minutes in this case.

      There is one additional comment field option which causes certain
      records to be created or not created.  Including "[rafcp]" in the
      comment section will cause WKS records indicating RAFCP support to be
      generated for the host and suppress generation of all MX records, even
      those specified with the -m option.  This is to support routable AFCP
      on the TIO-side of HP 3000s which use Telnet Express Boxes as front
      ends.

      By default, h2n will create a boot file, ./boot.cacheonly, for a
      caching-only name server.  If either of the -z or -Z options are used,
      h2n creates a boot file, named ./boot.sec.save or ./boot.sec
      respectively, for a secondary name server.
      NOTE: Certain h2n options (-v, -I audit) require that the dig
            program be installed.  dig is available in the standard BIND
            distribution at < http://www.isc.org/products/BIND/ >.

      Options are:

      -A   Don't create name server data for aliases in the host table.

      -a NET[:SUBNETMASK] [NET[:SUBNETMASK]] ...
           Add information about hosts from network NET to the DOMAIN
           database file.  This is similar to the -n option, but no PTR data
           is generated, i.e., no db.NET file is created.  This is useful
           when another server is responsible for address-to-name mapping,
           but this server is responsible for name-to-address mapping.
           Including more than one -a option is allowed.

      -b BOOTFILE
           Use BOOTFILE instead of the default: ./named.boot

      -B PATH
           Sets the directory where boot files will be written (named.boot,
           boot.sec and/or boot.sec.save, and boot.cacheonly).  You must
           specify an absolute pathname.

      -c REMOTE-DOMAIN [mode=[A][D[Q]]] [REMOTE-DOMAIN] ...
           Create CNAME records in the default domain for all the hosts in
           REMOTE-DOMAIN.  These CNAME records are generated before any
           other data in the default DOMAIN specified in the -d option, i.e,
           RR name conflicts favor the -c REMOTE-DOMAIN over the default
           DOMAIN.  Also, CNAME records are only generated for canonical
           names in REMOTE-DOMAIN - aliases are ignored.  This default
           behavior can be overridden by including one or more of the
           following mode= flags:
             A  Create additional CNAMEs for aliases in REMOTE-DOMAIN.
             D  Defer creation of CNAMEs, i.e., RR names in the default
                DOMAIN takes precedence over naming conflicts in the
                REMOTE-DOMAIN.
             Q  Do not issue a warning message when a deferred CNAME
                can not be created due to a naming conflict in the default
                domain.  Valid only when the "D" flag is also specified.
           Including more than one -c option is allowed.

      -C COMMENT-FILE
           Create resource records by using keys in the host table comment
           field as indices into COMMENT-FILE.  COMMENT-FILE contains
           "key:resource record" pairs like:  "720:IN HINFO hp9000s720 hp-
           ux".  When h2n encounters "720" in the comment section of the
           host table, it creates a resource record by replacing the "720:"
           with the host's canonical name.

      +c CONFFILE
           Use CONFFILE instead of the default: ./named.conf

      -d DOMAIN [db=FILE1] [spcl=FILE2] [mode=d]
           Your domain name is DOMAIN.  Use the db= and/or spcl= arguments
           to override the default filenames of db.LABEL and spcl.LABEL
           where LABEL is the first label of DOMAIN, e.g., label.movie.edu.
           Use the mode=d argument to set the default domain of unqualified
           canonical host names in the hostfile to DOMAIN.

      -e EXCLUDED-DOMAIN [EXCLUDED-DOMAIN] ...
           Exclude data from the hostfile with names in EXCLUDED-DOMAIN.
           Specifying more than one -e option is allowed.

      -f FILE
           Command line options are read from a file called FILE.  This
           option cannot be used within FILE.  Comments are allowed in FILE
           using the same style as in the host table or DNS database files,
           i.e., comments start after a '#' or ';' and continue to the end
           of the line.

      -h HOST
           Use HOST in the MNAME (master nameserver) field of the SOA
           record.  The default is the host on which you run h2n.

      -H HOSTFILE
           Use HOSTFILE instead of /etc/hosts.

      -i NUM
           Set the serial number of the zone to NUM.

      -I [ignore|warn|audit|warn-strict|fail|strict]
           Controls the level of checking done on hostnames for conformance
           to naming standards established by RFC-952 and RFC-1123.
           The -I option accepts one of the following arguments which
           are ordered such that each subsequent argument includes the
           functionality of the preceding one:
             ignore  Disables name checking.
               warn  Issues a warning about hostnames and domain names that
                     do not conform to RFC-952 and RFC-1123.
                     NOTE:  Hostname aliases that generate a CNAME record
                     type (the most common case) are generally not subject
                     to the restrictions of these two RFCs.
                     This flexibility of alias names allows the preservation
                     of an otherwise illegal hostname by making it become an
                     alias instead.
              audit  Issues a warning about -h/-s/-S/-m options that point
                     to CNAMEs or nonexistent domain names.  If a 'spcl'
                     forward-mapping file exists, the same checks are also
                     done with NS, MX and PTR records as well as checks for
                     dangling CNAMEs.  Delegated subdomains are checked for
                     having at least two listed nameservers, no missing glue
                     records, and NS RRsets with consistent TTL values.
                     This is the default setting.
        warn-strict  Extends conformance checking to the RFC-952 requirement
                     that hostnames and their aliases in the host table be
                     at least two characters in length.
               fail  Performs the same level of checking as the warn
                     argument except that non-compliant hostnames and
                     aliases are rejected.
             strict  Performs the same level of checking as the warn-strict
                     argument except that non-compliant hostnames and
                     aliases are rejected.

      -L NUM
           Explicitly use a file handle limit of NUM when generating
           database files.

      +L [LOG-SPEC]
           Add a logging specification to the config files (named.conf,
           conf.sec, conf.sec.save).  If you only specify "+L", you'll get a
           simple logging specification that will eliminate a lot of bogus
           information that would otherwise fill up your syslog.  You can
           override this by giving your own entries, e.g., "+L category
           lame-servers { null; };".  For each "+L LOG-SPEC" option you add,
           a line containing LOG-SPEC is added in the config file, thus
           including more than one +L option is allowed.  See the named(1M)
           man page for valid logging options.

      -m WEIGHT:MX-HOST [WEIGHT:MX-HOST] ...
           Include an MX record for each host in your domain pointing to
           MX-HOST at WEIGHT.  Including more than one -m option is allowed.

           Example:  -m 10:terminator.movie.edu 20:wormhole

      +m [D|C|P|CP]
           Controls the method by which DNS records get generated for hosts
           with multiple addresses.  By default, the canonical name of such
           multi-homed hosts is assigned an 'A' record for each address.
           Aliases unique to one address are also assigned an 'A' record.
           Aliases common to all addresses are assigned a CNAME record.  The
           PTR record for each address points to the multi-address canonical
           name.  This default behavior can be overridden by specifying one
           of the following flags:
             D  Same as the default behavior.
             C  The first alias unique to one address is still assigned
                an 'A' record but subsequent aliases unique to the address
                are assigned CNAME records which point to the first alias.
             P  PTR records do not point to the multi-address canonical name
                but instead point to the first alias having an 'A' record.
           Combining the C and P flags is allowed.  These global
           specifications can be overridden for any host by including the
           analogous "[mh=d|c|p|cp]" flag in its comment field.

      -M   Don't generate MX records.

      -n NET[:SUBNETMASK] [NET[:SUBNETMASK]] ...
           NET is your network number without the trailing zeros.  Including
           more than one -n option is allowed.  If SUBNETMASK is provided,
           create data for each subnet of NET.

           Example:  -n 192.249.249 15.15.16:255.255.248.0

      -N SUBNETMASK
           Apply SUBNETMASK to all network numbers instead of listing each
           subnet with -n.  Specifying a subnet mask with -n overrides the
           -N subnet mask for that network only.

      -o [REFRESH]:[RETRY]:[EXPIRE]:[MINIMUM]:[DEFAULT-TTL]
           Change the default SOA values to the values provided.  For
           nameservers running versions of BIND prior to 8.2, the default
           values are (10800:3600:604800:86400).  For versions 8.2 and later
           which implement RFC-2308, the defaults are (3h:1h:1w:10m:1d) with
           DEFAULT-TTL appearing in a $TTL directive and MINIMUM being
           semantically treated as a negative caching value .
           If DEFAULT-TTL is not specified, h2n will try to determine the
           BIND version of the master nameserver (-h option or localhost)
           and act accordingly.
           NOTE: These built-in default values do not override those in zone
                 files that already exist.  Use the -o option to specify SOA
                 values that will override those in existing zone files as
                 well as becoming the default values for new zone files.

           Example:  -o ::::8h   generates $TTL 8h in all zone files.

      -O OPTION OPTION-ARGS
           Add a boot option specification to the boot files (named.boot,
           boot.sec, boot.sec.save), e.g., "-O options no-round-robin".  See
           the named man page for valid options.  Including more than one -O
           option is allowed.

      +O [OPTION-SPEC]
           Add an option section specification to the config files
           (named.conf, conf.sec, conf.sec.save), e.g., "+O round-robin
           no;".  See the named man page for valid options.  Including more
           than one +O option is allowed.  For each "+O OPTION-SPEC", a new
           line containing OPTION-SPEC is added to the config file.  If you
           use a single +O option without an argument, the global options
           section will not be generated.  This is useful if you want to
           maintain a main named.conf file for your master and slaves with a
           complex mix of options {}, logging {}, and other global sections,
           and 'include' the h2n-generated zone sections.  Combine this with
           a +c option.

      +om OPTION OPTIONS-ARGS
           Adds a zone-specific option to the config file (named.conf),
           e.g., "+om also-notify { 15.1.2.3; 15.1.2.4; };".  This option is
           position dependent and applies to the last -d or -n option
           specified, however, if a +om option appears before any -d or -n
           options it is assumed that the +om option applies to all zones.
           Thus, it will be added to each zone section in the config file.

      +os OPTION OPTIONS-ARGS
           Adds a zone-specific option to the config files (conf.sec and/or
           conf.sec.save), e.g., "+os max-transfer-time-in 60;".  Like the
           +om option, it is position dependent and applies to the last -d
           or -n option specified.  Also, if a +os option appears before any
           -d or -n options it is assumed that the +os applies to all zones.

      -p REMOTE-DOMAIN [mode=[A][P]] [REMOTE-DOMAIN] ...
           Create only PTR data for hosts in REMOTE-DOMAIN.  This is useful
           when a different server is responsible for the forward (name-to-
           address) mapping data of REMOTE-DOMAIN but this server is
           responsible for the reverse (address-to-name) mapping data of
           each -n option.  Including more than one -p option is allowed.
           The mode= argument may need to be specified with one of the
           following flags:
             A  Required for each REMOTE-DOMAIN which had its forward
                mapping data built with the -A option.  This prevents
                dangling PTR records from being generated for multi-homed
                hosts in REMOTE-DOMAIN having the "[mh=p]" or "[mh=cp]" flag
                in the comment field.  Can also be specified as an override
                flag for REMOTE-DOMAIN when the '+m P' option is in effect.
             P  Enables the alternate method of PTR record generation for
                multi-homed hosts in REMOTE-DOMAIN as previously described
                for the '+m P' option when that option is *not* in effect.
                This method is overridden for any host in REMOTE-DOMAIN
                having the "[mh=d]" or "[mh=c]" flag in its comment field.

      -q   Work quietly.

      -r   Enable creation of RP (Responsible Person) records.  Look for
           strings in the comment section of the host table that match
           "[rp=mail-addr [text]]", where mail-addr is a usual e-mail
           address specification, and (optionally) text is a free-form text
           string (usually containing a phone number and/or pager number, or
           other info).  This construct is converted to an RP record
           containing the e-mail address, and if text is present, a TXT
           record is also added containing text (with the RP record
           referencing the TXT record).

      -s SERVER [SERVER] ...
           List SERVER for all zones.  Adds NS records for the zone(s)
           corresponding to the -d option and all -n options.  Including
           more than one -s option is allowed.

      -S SERVER [SERVER] ...
           List SERVER for specific zone(s).  Adds NS records for the
           zone(s) corresponding to the last preceding -d or -n option (this
           option is position dependent).  There can be multiple zones if
           this applies to a -n option.  Including more than one -S option
           is allowed.

      -t   Generate TXT records from the host table comment section.  Any
           special processing options are ignored, e.g., [no smtp].

      +t DEFAULT-TTL [MINIMUM-TTL]
           Create RFC-2308 $TTL directives in all zone files.  If MINIMUM-
           TTL is specified, use that instead of the default of 10 minutes
           (600).

      -u USER
           Use USER as the e-mail address in the RNAME (responsible person)
           field of the SOA record.  USER should be a complete mail address,
           e.g.,  me@a.b.c .  Defaults to root@DOMAIN (-d option).  Periods
           in the username-portion of the address, e.g., first.last@a.b.c ,
           will be escaped if necessary.
           NOTE: If USER lacks the "@" symbol and has a trailing period,
                 RNAME format will be assumed and USER left unchanged.

      -v domain [domain]
           Verify the integrity of a domain by performing a zone transfer
           and analyzing the data.  All of the checks described above for
           the -I audit option are done plus those for "CNAME and other
           data" errors.  In addition, listed nameservers are checked for
           proper delegation.

      -w   Generate WKS records that list the SMTP service over the TCP
           protocol if an MX record is also created.

      -W PATH
           Sets the directory where db files will be located on the primary
           and secondary name servers.  This is useful if you build new db
           files on a host other than the primary.  You must specify an
           absolute pathname.

      -y   Use the date to create the serial number.  The date format used
           is YYYYMMDDXX.  YYYY is the year.  MM is the month.  DD is the
           day of the month.  XX is counter that starts at 00 and increments
           each time h2n-hp is run on the same day.  The -y option will be
           ignored for zones in which the existing serial number is larger
           than the computed date-based serial number.

      -z ADDRESS [ADDRESS]
           Create a boot file, ./boot.sec.save, for a secondary name server
           that lists ADDRESS as the master to load from, and save a copy of
           the zone data in a backup file.  (This option is similar to the
           -Z option.)  Including more than one -z option is allowed.

      -Z ADDRESS [ADDRESS]
           Create a boot file, ./boot.sec, for a secondary name server that
           lists ADDRESS as the master to load from, and do not save a copy
           of the data in a backup file.  (This option is similar to the -z
           option.)  Including more than one -Z option is allowed.

      -recurse
           Enables delegated subdomains to be recursively verified after
           completing verification of the parent domain with the -v option.

      -no-check-del
           Disables delegation checking when verifying one or more domains
           with the -v option.  Such checks can take a long time if a large
           number of unresponsive nameservers are encountered.

      -show-chained-cnames
           Displays each element of a CNAME chain to which an out-of-zone
           CNAME points.  The default behavior is to ignore CNAME chains
           that successfully resolve and display just the chain length of
           dangling or looping CNAMEs.

 EXAMPLES
      Create name server data for networks 192.249.249 and 192.253.253 in
      movie.edu.

      h2n -d movie.edu -n 192.249.249 -n 192.253.253

      Create name server data for networks 192.249.249 and 192.253.253 in
      movie.edu.  Eliminate lines in the host table that contain
      fx.movie.edu and include MX records for all hosts pointing to the mail
      hub, postmanrings2x.movie.edu.  Afterwards, look for additional
      resource records in the file "spcl.movie.edu" and append them to
      "db.movie" via an $INCLUDE directive.  Include all of the options in a
      file.

      h2n -f option_file

      option_file contains the following lines:

      -d movie.edu  spcl=spcl.movie.edu
      -n 192.249.249
      -n 192.253.253
      -e fx.movie.edu
      -m 50:postmanrings2x.movie.edu

