

######################################################################
# Ask gnome where to install things, and set $datapath and
# $pixmappath. 

				# nonlocal installation?
if( !@ARGV || $ARGV[0] !~ /^-?local$/ ){ 
    $datapath = `gnome-config --datadir` ;
    $datapath =~ s|/?\n?$||;	# Clean ending

				# Tentative pixmap path
    ($pixmappath = "$datapath/pixmaps") =~ s{/+}{/}g ;
				# Path to puzzles
    ($datapath .= "/games/bloksi") =~ s{/+}{/}g ;

} else {			# local installation
    $datapath = "./data" ;
    $pixmappath = "./data"
}

$personalpath = "~/.bloksi" ;

######################################################################
use ExtUtils::MakeMaker;

{ 
    my  @a= localtime(time());
    my $s = sprintf("%04d.%02d.%02d",1900+$a[5],$a[4]+1,$a[3]);
    if( 0 ){
	$s .= sprintf(".%02dh%02d",$a[2],$a[1]);
    }
    $VERSION = $s ;
}


######################################################################
# Create BloksiPath.pm so that bloksi knows where to find puzzles and
# pixmaps. 
open DATAPATH, ">BloksiPath.pm" or die "Can't open 'BloksiPath.pm'" ;
print DATAPATH <<EOF
## Created by Makefile.PL. 
## This file defines where "bloksi" will look for puzzles and pixmaps.
\$Bloksi::datapath =  "$datapath" ;
\$Bloksi::pixmappath =  "$pixmappath" ;
\$Bloksi::personalpath =  "$personalpath" ;
\$Bloksi::VERSION = "$VERSION" ;
EOF
;

######################################################################
# Facilitate my life for installing things on web page.

$dname = "bloksi-$VERSION.tar.gz";
$scmd = join "; ", 
    "\$b=qq(<a href=\"$dname\">$dname</a><br>\\n)",
    "\$_=\$b.\$_ if \$a==1 && \$_ ne \$b",
    "\$a=0",
    "\$a=1 if m(^<h2>Download</h2>)" ;
## Dollars should be doubled in Makefile
$scmd =~ s/\$/\$\$/mg ;
# print "scmd = '$scmd'\n" ;
# print "dname = $dname\n";

# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.
$Verbose = 1;



WriteMakefile(

	      'NAME'         => 'bloksi',
	      'VERSION'      => $VERSION,
	      
	      'PM'           => {
		  'Bloksi.pm'       => '$(INST_LIBDIR)/Bloksi.pm',
		  'BloksiPath.pm'   => '$(INST_LIBDIR)/BloksiPath.pm',
		  'Bloksi/Parse.pm' => '$(INST_LIBDIR)/Bloksi/Parse.pm',
		  'Bloksi/CanvasBloksi.pm'
		      =>'$(INST_LIBDIR)/Bloksi/CanvasBloksi.pm' }, 

	      'EXE_FILES'    => ['bloksi'],

	      'MAN1PODS'     => {'bloksi'=>'$(INST_MAN1DIR)/bloksi.6'},
	      'MAN3PODS'     => {'bloksi_format.pod'=>
				 '$(INST_MAN3DIR)/bloksi_format.6'},

	      'clean'        => {'FILES'  => '*~ *.bak */*~ */*.bak'},  
	      'dist'         => { COMPRESS => "gzip -9f",
				  SUFFIX => 'gz',
			      },
	      );


sub MY::postamble 
{ join( "\n", 
	"tags:",
	"\tetags bloksi *.pm */*.pm *.pl",
	"\n" ,
	"install::\tcopydata",
	"pure_install::\tcopydata",
	"\n" ,
	"copydata:\tdata/*",
	"\tmkdir --parents $datapath",
	"\tmkdir --parents $pixmappath",
	"\tcp data/*.lev data/*.png $datapath" ,
	"\tcp data/bloksi_target.xpm $pixmappath/bloksi_target.xpm" ,
	"\n",
	"uninstall::\tuninstalldata",
	"\n" ,
	"uninstalldata:",
	"\trm $datapath/*.lev" ,
	"\trm $pixmappath/bloksi_target.xpm" ,
	"\trmdir $datapath" ,
	"\n",
	"webfiles:",
	"\tcp README INSTALL BUGSandTODO Changelog COPYING $ENV{HOME}/public_html/bloksi",
	"\tcp $dname $ENV{HOME}/public_html/bloksi",
	"\tperl -pi.bak -e '$scmd' $ENV{HOME}/public_html/bloksi/index.html",
	"\n",
	"mydist:\tlocal dist",
	"\n",
	"local:",
	"\tcat BloksiLocalPath.pm >> BloksiPath.pm"
	);
}
