// BanEntry.H  -*- C++ -*-
// Copyright (c) 1997, 1998 Etienne BERNARD

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef BANENTRY_H
#define BANENTRY_H

#include <time.h>

#include "Mask.H"

class Commands;
class UserCommands;

class BanEntry {
  Mask banMask;
  time_t expirationDate;
  
public:

  BanEntry(String, time_t);
  
  time_t getExpirationDate() const;
  void setExpirationDate(time_t);

  String getMask();

  friend class Commands;
  friend class UserCommands;
};

#endif
