// Bot.H  -*- C++ -*-
// Copyright (c) 1997, 1998 Etienne BERNARD

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef BOT_H
#define BOT_H

#include <time.h>
#include <set.h>
#include <fstream.h>

#include "String.H"
#include "Person.H"
#include "ServerList.H"
#include "ChannelList.H"
#include "UserList.H"
#include "ShitList.H"
#include "TodoList.H"
#include "Parser.H"

#ifdef USESCRIPTS
#include "BotInterp.H"
extern "C" {
#include <guile/gh.h>
}
#endif

#define VERSION_STRING   "Bobot++ version 1.97 by eb@IRCNet <eb@via.ecp.fr>"
#define COPYRIGHT_STRING "Bobot++ version 1.97, Copyright (C) 1997-2000 Etienne BERNARD"

class Channel;
class DCCConnection;
class Parser;
class DCCParser;
class ServerConnection;
class Commands;
class UserCommands;
class Utils;

class Bot {
public:
  String nickName;
  String wantedNickName;
  String userName;
  String ircName;
  String versionString;
  String userHost;
  String localIP;
  char commandChar;

  String configFileName;
  String userListFileName;
  String shitListFileName;
  String logFileName;
  String helpFileName;
  String initFileName;
#ifdef USESCRIPTS
  String scriptLogFileName;
  String autoexecFileName;
#endif

  ofstream logFile;

  bool connected;
  bool debug;
  bool stop;
  bool sentPing;

  ChannelList * channelList;
  UserList * userList;
  ShitList * shitList;
  ServerList * serverList;
  TodoList * todoList;
#ifdef USESCRIPTS
  BotInterp * botInterp;
#endif
  list<class userFunction *> userFunctions;

  map<String, wantedChannel *, less<String> > wantedChannels;

  map<String, unsigned int, less<String> > ignoredUserhosts;
  map<String, Person *, less<String> > spyList;

  time_t startTime, currentTime, lastNickNameChange, lastChannelJoin;

  ServerConnection * serverConnection;
  list<DCCConnection *> dccConnections;

  map<unsigned long, String, less<unsigned long> > userhostMap;
  unsigned long sentUserhostID;
  unsigned long receivedUserhostID;

  static const unsigned int MAX_MESSAGES = 2;
  static const time_t NICK_CHANGE  = 60;
  static const time_t CHANNEL_JOIN = 60;
  static const time_t IGNORE_DELAY = 180;
  static const time_t DCC_DELAY = 300;
  static const time_t PING_TIME = 90;
  static const time_t TIMEOUT = 120;

public:

  Bot(String, bool=false);
  ~Bot();

  void run();

  void waitForInput();

  void logLine(String);
  void readConfig();

  void reconnect();

  friend class Parser;
  friend class DCCParser;
  friend class Person;
  friend class Channel;
  friend class Utils;
  friend class ServerConnection;
  friend class UserCommands;
  friend class Commands;
  
private:
  bool canChangeServer();
  void nextServer();
  void connect(int);

  void addDCC(Person *, unsigned long, int);

  void rehash();
  String getUserhost(String, String);
  bool iAmOp(String);
};

#endif
