// ServerList.H  -*- C++ -*-
// Copyright (c) 1997, 1998 Etienne BERNARD

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef SERVERLIST_H
#define SERVERLIST_H

#include <vector.h>

#include "Server.H"

#ifdef USESCRIPTS
class ScriptCommands;
#endif
class UserCommands;

class ServerList {
  vector<Server *> v;
  vector<Server *>::iterator it;
  Server * current;
  int currentNumber;

  vector<Server *>::iterator begin()
    { return v.begin(); }
  vector<Server *>::iterator end()
    { return v.end(); }

public:
  ServerList();
  ~ServerList();
  
  void addServer(Server *);
  void delServer(int);

  Server * nextServer();
  Server * currentServer();

  Server * get(int n) const { return v[n]; }
  int size() { return v.size(); }

#ifdef USESCRIPTS
  friend class ScriptCommands;
#endif
  friend class UserCommands;
};

#endif
