#ifndef _FIXEDLENGTH_CPP_
#define _FIXEDLENGTH_CPP_

#include <iostream.h>

#include <reference.h>
#include <table.h>
#include <event.h>
#include <part.h>
#include <track.h>
#include <song.h>
#include <str.h>
#include <prMainEditor.h>

#include "fixedLength.h"

extern Table * selectioN;
extern Table * selectionMemory;
extern PrMainEditor * mainEditor;

#define FIXEDLENGTH_CONTEXT Addon::TREAT_SELECTION + Addon::TREAT_TRACK + Addon::TREAT_PART + Addon::TREAT_SONG

extern "C" {
  Addon * fixedLength(Element * target) { return new FixedLength(target); }
  const char  * fixedLength_name() { return "set fixed length"; }
  const char  * fixedLength_category() { return "quantize"; }
  int     fixedLength_context() { return FIXEDLENGTH_CONTEXT; }
}


FixedLength::FixedLength(Element * target) : Addon("quantize", target, !TO_BE_UNDONE, FIXEDLENGTH_CONTEXT) { run(); }

FixedLength::~FixedLength() {

}

void setLength(Event * ev, int grid) {
  ev->setDuration(grid);
}

void FixedLength::selection(Table * selection) {
  int grid = mainEditor->grid();
  for (Reference * r = (Reference*)selection->first(); r != 0; r = (Reference*) Element::next(r)) {
    Event * ev = (Event*) r->getValue();
    //ev->snapStart(grid);
    setLength(ev,grid);
  }
}

void FixedLength::part(Part * part) {
  int grid = mainEditor->grid();
  for (Event * ev = (Event*)part->first(); ev != 0; ev = (Event*) Element::next(ev)) {
    //ev->snapStart(grid);
    setLength(ev,grid);
  }
}

void FixedLength::track(Track * track) {
  int grid = mainEditor->grid();
  int sz = track->size();
  for (int i=0; i<sz; i++) {
    Part * pt = (Part*) track->get(i);
    for (Event * ev = (Event*) pt->first(); ev != 0; ev = (Event*) Element::next(ev)) {
      //ev->snapStart(grid);
      setLength(ev,grid);
    }
  }
}

void FixedLength::song(Song * song) {
  int grid = mainEditor->grid();
  int szs = song->size();
  for (int i=0; i<szs; i++) {
    Track * track = (Track*) song->get(i);
    int sz = track->size();
    for (int i=0; i<sz; i++) {
      Part * pt = (Part*) track->get(i);
      for (Event * ev = (Event*) pt->first(); ev != 0; ev = (Event*) Element::next(ev)) {
	//ev->snapStart(grid);
	setLength(ev,grid);
      }
    }
  }
}

void FixedLength::undo() {
}

void FixedLength::redo() {
}






#endif
