#ifndef _LOADER_CPP_
#define _LOADER_CPP_

#include <version.h>

#include <iostream.h>
#include <fstream.h>
#include <string.h>
#include <stdlib.h>
#include <fstream.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <stdio.h>
#include <fcntl.h>
#include <math.h>

#include "loader.h"
#include "song.h"
#include "table.h"
#include "reference.h"
#include "str.h"

#include "prProgress.h"
#include "prMainEditor.h"

extern PrMainEditor * mainEditor;


#ifndef DEBUGIT
#define DEBUG(X) //
#define DEBUG2(X,Y) //
#define DEBUG3(X,Y,Z) //
#else
#define DEBUG(X) cout << X << endl 
#define DEBUG2(X,Y) cout << X << Y << endl 
#define DEBUG3(X,Y,Z) cout << X << Y << "(" << Z << ")" << endl 
#endif


char * getcmd(char * s) {
  char * retv = s;
  while (retv[0]!='<') retv++;
  retv++;
  return retv;
}


void getVersion(int & a, int & b, int & c, const char * line) {
  if (line!=0) {
    a = atoi(line);
    int len = strlen(line);
    int dots = 0;
    for (int i=0; i<len; i++) if (line[i]=='.') dots++;
    if (dots>0) {
      const char * ptrB = line;
      const char * ptrC = line;
      while (ptrB[0]!='.') ptrB++;
      ptrB++;
      b = atoi(ptrB);
      if (dots>1) {
	ptrC = ptrB;
	while (ptrC[0]!='.') ptrC++;
	ptrC++;
	c = atoi(ptrC);
      }
    }
  }
}


Loader::Loader() {

}


Song * Loader::load(const char * fname, PrProgress * progress) {
  // cout << "loading " << fname << endl;
  Song * song = 0;
  int num; int maj = 0; int min = 0;
  ifstream * in = new ifstream(fname);
  Table * attr = 0;
  if (*in!=0) attr = Loader::getAttributes("DOCUMENT",in);
  if (*in!=0 && attr!=0) {
    const char * version = ((String*) attr->getEntry("version"))->getValue();
    // char * version = "0.97.4\0";
    getVersion(num,maj,min,version);
    // cout << "Version " << num << "." << maj << "." << min << endl;
    double versionKey = num*100+maj+0.1*min;
    // cout << "key: " << versionKey << endl;
    song = (Song*) Song::load(in,versionKey,progress);
    attr->scratch();
    delete attr;
	if (progress) progress->hide();
	song->updateGui(false);
  } else {
    // cout << "not a Brahms file" << endl;
    if (song!=0) delete song;
    song = 0;
  }
  return song;
}

void Loader::save(const char * fname, Song * song) {
  // cout << "writing " << fname << endl;
  ofstream * out;

  /*
  const char * pdir = mainEditor->projectDir();
  if( pdir != 0 )
  {
    int i = 0;
    int len = strlen(fname);
    for (i=len-1; i>=0 && fname[i]!='/'; i--) {}
    char * fn = (char*) fname;
    if (i>=0) fn = (char*) fname[i+1];
    char * name = new char[strlen(fname) + strlen(pdir) + 1];
    sprintf(name,"%s%s",pdir,fname);
    cout << "writing " << name << endl;
    out = new ofstream(name);
  }
  else
  {
    cout << "writing " << fname << endl;
    }*/
  out = new ofstream(fname);

  ofstream &to = *out;
  to << "<?XML version=\"1.0\"?>" << endl;
  to << "<!DOCTYPE Brahms SYSTEM \"Brahms.dtd\">" <<endl;
  to << "<DOCUMENT version=\"" << BRAHMS_VERSION << "\">" << endl;
  to << *song << "</DOCUMENT>" << endl;
  to.close();
  song->updateGui(false);
}


Table * Loader::getAttributes(const char * s, ifstream *& inPtr) {
  Table * table = 0;
  if (s!=0) {
    int len = strlen(s);
    ifstream &in = *inPtr;
    char * line = new char[401];
    char * ptr = line;
    line[0] = 0;
    bool ok = 1;
    while ((ok==1)&&(strncmp(ptr,s,len)!=0)) {
      ok = in.getline(line,400,'\n');
      if (ok!=0) ptr = getcmd(line);
    }
    if (ok!=0) table = getAttributes(s,line);
    delete line;
  }
  return table;
}

Table * Loader::getAttributes(const char * s, char * line) {
  Table * table = 0;
  if ((s!=0)&&(line!=0)) {
    char * ptr = getcmd(line);
    int len = strlen(s);
    if (strncmp(ptr,s,len)==0) {
      table = new Table();
      ptr += len;
      char * end = ptr;
      while (end[0] != '>') end++;
      bool ok = 1;
      while (ok==1) {
	// cout << ptr << ", " << end << endl;
	if (ptr+3 > end) {
	  ok = 0;
	} else {
	  while (ptr[0]==' ') ptr++;
	  char * key0 = ptr;
	  while ((ptr[0]!='=') && (ptr[0]!=' ')) ptr++;
	  char * key1 = ptr;
	  int keyLen = key1 - key0;
	  char * key = new char[keyLen+1];
	  strncpy(key,key0,keyLen);
	  key[keyLen]=0;
	  while (ptr[0]!='=') ptr++;
	  while (ptr[0]!='"') ptr++;
	  ptr++;
	  char * val0 = ptr;
	  while (ptr[0]!='"') ptr++;
	  char * val1 = ptr;
	  int valLen = val1 - val0;
	  char * val = new char[valLen+1];
	  strncpy(val,val0,valLen);
	  val[valLen]=0;
	  //cout << "add (" << key << ", " << val << ")" << endl;
	  ((Compound*)table)->add(new Reference(key,new String(val)));
	  ptr++;
	}
      }
    }
    
  }
  return table;
}



// *********************************************
// **                                         **
// **                                         **
// **               MIDI stuff                **
// **                                         **
// **                                         **
// *********************************************

// DOIT: Masterevents?!

#include "note.h"
#include "masterEvent.h"
#include "midiEvent.h"
#include "symbol.h"
#include "track.h"
#include "scoreTrack.h"
#include "part.h"

#define GET(X) read(in,quad,X)
#define PROGRESS(X) percentD += X*percStep; if ((progress!=0) && (int(percentD)>percent)) { progress->progress(int(percent)); percent = int(percentD); }
#define MAXSUS 512


int read(ifstream & in, unsigned char * buf, int len) {
  if (len>4) cout << "PANIC: only 4 bytes are allocated, but " << len << " bytes are used!!" << endl;
  unsigned char ch;
  int i = 0;
  for (i=0; i<len; i++) {
    in.get(ch);
    buf[i] = ch;
  }
  buf[i] = 0;
  return buf[i-1];
}

void addToPart(Event * ev, Part *& part, Track *& track, Song *& song, int prg, int chn) {
  if (!part) {
    track = new ScoreTrack();
    song->add(track);
    part = new Part(track);
    track->add(part);
    ((ScoreTrack*)track)->setChannel(chn);
    ((ScoreTrack*)track)->setProgram(prg);
    part->setProgram(prg);
  }
  part->add(ev);
}

// Song * Loader::loadMidi(ifstream * inPtr) {
Song * Loader::loadMidi(const char * fname, PrProgress * progress) {
  ifstream * inPtr = new ifstream(fname);
  ifstream &in = *inPtr;

  Song* song = new Song();

  Track * track;
  unsigned char* quad= new unsigned char[5];
  
  unsigned char ch;
  int i;
  int lo;
  int hi;

  int run;
  int t;
  int cmd;
  int len;
  int tempo;
  int time1;
  int time2;
  int keysf;
  int keymi;
  int d;
  int dd;
  int getnote;
  int note;
  int vel;
  int ctrl;
  int val;
  int prg;
  int chn;
  int btm;
  int top;
  unsigned char* name;
   
  int numTr;
  int delta;

  int noteOn=-1;
  int channel=0;

  int percent = 0;
  double percentD = 0;
  int absLength = 0;
  double percStep = 1;

  int prgs[64];
  for (int uu=0; uu<64; uu++) prgs[uu]=0;

  Note* sus[MAXSUS];
  Note* newNote;
  int susp=0;

  unsigned char* tr[64];
  int tracklength[64];

  GET(4);
  if (!strcmp((char*)quad,"MThd")) {
    i = GET(4);
    if (i!=6) { DEBUG("strange header length");
    } else {
      i = GET(2);
      // DEBUG2("Fileformat: ", i);
      GET(4);
      numTr=int(quad[1])+256*int(quad[0]);
      delta=int(quad[3])+256*int(quad[2]);
      // DEBUG2("Tracks: ", numTr);
      // DEBUG2("DeltaT: ", delta);

      for (int trackn=0; trackn<numTr; trackn++) {
	      
	// DEBUG2("entering track ", trackn);
	GET(4);
	if (strcmp((char*)quad,"MTrk")) { DEBUG("not a MIDI track"); numTr=0; }
	GET(4);
	tracklength[trackn]=int(quad[3])+256*int(quad[2])+65536*int(quad[1])+16777216*int(quad[0]);
	// DEBUG2("tracklength: ", tracklength[trackn]);
	tr[trackn] = new unsigned char[tracklength[trackn]+2000];
	for (int qq=0; qq<tracklength[trackn]; qq++) { in.get(ch); tr[trackn][qq]=ch; }
	absLength += tracklength[trackn];
      }
      if (progress!=0) {
	percStep = 1.0*progress->range()/absLength;
	progress->progress(0);
      }
      for (int trackn=0; trackn<numTr; trackn++) {
	// DEBUG3("\n\ntracklength[num](trackn):", tracklength[trackn], trackn);
	Part * part = 0;
	track = 0;
	run=1;
	t = 0;
	name=new unsigned char[150];
	name[0]='-';
	name[1]=0;
	int totalTime=0;
	susp = 0;
	while (run) {
	  dd=0; while ((d=int(tr[trackn][t++]))>128) { dd*=128; dd+=int(d)&127; PROGRESS(1.0); }
	  dd*=128; dd+=int(d)&127;
	  PROGRESS(1.0); // because there is one t++ in the condition!
	  totalTime+=dd;
	  i=int(tr[trackn][t++]);
	  PROGRESS(1.0);
	  if (i<0) i+=256;
	  lo=i&15;
	  hi=(i&240)/16;
	  getnote=0;
	  if (i==255) {
	    cmd=int(tr[trackn][t++]);
	    len=int(tr[trackn][t++]);
	    PROGRESS(2.0);
	    if (cmd==0x51) {
	      tempo=int(tr[trackn][t])+256*int(tr[trackn][t+1])+65536*int(tr[trackn][t+2]);
	      // DEBUG2("tempo: ", tempo);
	    } else if (cmd==0x58) {
	      time1=int(tr[trackn][t]); time2=int(tr[trackn][t+1]);
	      //DEBUG2("time1: ", time1);
	      //DEBUG2("time2: ", time2);
	    } else if (cmd==0x59) {
	      keysf=int(tr[trackn][t]); keymi=int(tr[trackn][t+1]);
	      // DEBUG3("key (minor): ", keysf, keymi);
	    } else if (cmd==0x03) {
	      if (len>0) {
		strncpy((char*)name,(char*)&tr[trackn][t],len);
		name[len]=0;
		if (track!=0) track->setName((char*)name);
	      }
	      // DEBUG2("name: ", name);
	    } else if (cmd==0x2f) { run=0;
	    } else { 
	      strncpy((char*)name,(char*)&tr[trackn][t],len);
	      name[len]=0;
	      DEBUG3("cmd: ", cmd, name);
	    }
	    t+=len;
	    PROGRESS(len);
	  } else if (hi==9) {
	    // DEBUG("Note on");
	    noteOn=1;
	    channel=lo;
	    i=int(tr[trackn][t++]);
	    getnote=1;
	    PROGRESS(1.0);
	  } else if (hi==8) {
	    // DEBUG("Note off");
	    noteOn=0;
	    channel=lo;
	    i=int(tr[trackn][t++]);
	    getnote=1;
	    PROGRESS(1.0);
	  } else if (hi==10) {
	    // DEBUG("Aftertouch");
	    note=int(tr[trackn][t++]);
	    vel=int(tr[trackn][t++]);
	    noteOn=3;
	    addToPart(new MidiEvent(totalTime,i,note,vel),part,track,song,prgs[lo],lo);
	    PROGRESS(2.0);
	  } else if (hi==11) {
	    // DEBUG("Ctrl Change");
	    ctrl=int(tr[trackn][t++]);
	    val=int(tr[trackn][t++]);
	    noteOn=4;
	    addToPart(new MidiEvent(totalTime,i,ctrl,val),part,track,song,prgs[lo],lo);
	    PROGRESS(2.0);
	  } else if (hi==12) {
	    // DEBUG("Prg Change");
	    prg=int(tr[trackn][t++]);
	    prgs[lo]=prg;
	    noteOn=5;
	    //part->program = prg; // DOIT: if prg-change, create new Part!
	    //part->trAdr->program = prg;
	    // DOIT: if prg-change, create new Part!
	    if (track!=0) ((ScoreTrack*)track)->setProgram(prg);
	    if (part!=0) part->setProgram(prg);
	    // DOIT: maybe one wants the events also:
	    // addToPart(new MidiEvent(totalTime,i,prg),part,track,song);
	    PROGRESS(1.0);
	  } else if (hi==13) {
	    // DEBUG("Channel Aftertouch");
	    chn=int(tr[trackn][t++]);
	    noteOn=6;
	    addToPart(new MidiEvent(totalTime,i,chn),part,track,song,prgs[lo],lo);
	    PROGRESS(1.0);
	  } else if (hi==14) {
	    // DEBUG("Pitch Wheel");
	    btm=int(tr[trackn][t++]);
	    top=int(tr[trackn][t++]);
	    noteOn=7;
	    addToPart(new MidiEvent(totalTime,i,btm,top),part,track,song,prgs[lo],lo);
	    PROGRESS(2.0);
	  } else if (hi==15) {
	    DEBUG("HI=15");
	    noteOn=8;
	  } else { 
	    getnote=1;
	  }
	  if (getnote) {
	    note=i; vel=int(tr[trackn][t++]);
	    PROGRESS(1.0);
	    if ((vel==0)&&(noteOn==1)) noteOn=0;
	    if (noteOn == 1) {
	      /*
	      if (!part) {
		track = new ScoreTrack();
		song->add(track);
		part = new Part();
		track->add(part);
		part->setProgram(prg);
		((ScoreTrack*)track)->setProgram(prg);
		track->setName((char*)name);
	      }
	      newNote = new Note(note,vel,191,totalTime,0);
	      part->add(newNote);*/

	      newNote = new Note(note,vel,191,totalTime,0);
	      addToPart(newNote,part,track,song,prgs[lo],lo);
	      if (susp<MAXSUS) sus[susp++]=newNote;
	      else cout << "PANIC!!!!!!" << endl;
	    } else if (noteOn == 0) {
	      int ii=0;
	      for (int i=0; i<susp; i++)
		if ((note==sus[i]->pitch()))
		  {
		    sus[i]->setDuration(totalTime-sus[i]->internalStart().ticks());
		    ii=i;
		    i=susp;
		  }
	      for (int i=ii; i<susp-1; i++) sus[i]=sus[i+1];
	      if (susp>0) susp--;
	    }
	    if ((vel==0)&&(noteOn==0)) noteOn=1;
	  }
	  if (t>tracklength[trackn]) {run=0;cout << "PANIC length-error, t:" << t << ", tl[tn]:" << tracklength[trackn] << endl;}
	}	  
      }
      if (progress!=0) progress->progress(progress->range());
    }
  } else {
    cout << "not a MIDI file" << endl;
    if (song!=0) delete song;
    song = 0;
  }
  if (progress) progress->hide();
  // adjustRightBorder();
  // gInterface()->update();
  
  return song;
}


Loader foo;

#endif
