#ifndef _SCOREITERATOR_CPP_
#define _SCOREITERATOR_CPP_

#include "scoreIterator.h"
#include <iostream.h>
#include <fstream.h>
#include <stdlib.h>
#include <string.h>
#include "track.h"
#include "part.h"
#include "event.h"
#include "masterEvent.h"
#include "note.h"
#include "prScoreEditor.h"
#include "scoreBar.h"
#include "scoreTrack.h"
#include "prMainEditor.h"
#include "song.h"

extern Song * sonG;
extern PrMainEditor * mainEditor;

ScoreIterator::ScoreIterator(const ScoreIterator & i) : Iterator(i), _systems(i._systems), _res(i._res), _no_overlap(i._no_overlap) { cout << "+++" << endl; }


ScoreIterator::ScoreIterator(PrScoreEditor * editor, int xoff, Position lpos, Position rpos)
  : _editor(editor), _systems(editor->parts()), _res(editor->resolution()), _no_overlap(editor->noOverlap()), _width(editor->editorWidth()), _xoffset(xoff),
    _lpos(lpos.ticks()), _rpos(rpos.ticks())
{
  init();
}

ScoreIterator::~ScoreIterator() {

  for (int i=0; i<_systems; i++)
    delete _iterator[i];
  delete[] _iterator;
  delete[] _bar;
  delete[] _ref_bar;

}


void ScoreIterator::init() {
  //
  // init
  //
  Table * tab = new Table();
  Part * activePart = _editor->part();

  _iterator = new SystemIterator* [_systems];
  _bar = new ScoreBar* [_systems];
  _ref_bar = new ScoreBar* [_systems];
  int index = _editor->partIndex();
  for (int i=0; i<_systems; i++) {
    _editor->setPart(i);
    _iterator[i] = new SystemIterator(MULTIPLESCORE, _editor->part(i)->track(), _editor, activePart, _lpos, _rpos);
  }
  if (index==-1) cout << "PANIC!!!" << endl;
  else _editor->setPart(index);

  _ptr = 0;
  _max = 0;
  for (int i=0; i<_systems; i++)
    if (_max < _iterator[i]->size()) _max = _iterator[i]->size();

  _xpos = _xoffset;

  int rwd = 0;
  int indent = 0;
  int sysrwd = 0;
  int sysindent = 0;

  for (int i=0; i<_systems; i++) {
    _bar[i] = (ScoreBar*) _iterator[i]->operator*();
    _ref_bar[i] = _bar[i];
  }

  for (int b = 0; b < _max; b++) {
    rwd = 0;
    indent = 0;
    for (int i=0; i<_systems; i++) {
      sysrwd = _bar[i]->rawWidth();
      sysindent = _bar[i]->systemIndent();
      if (rwd < sysrwd) rwd = sysrwd;
      if (indent < sysindent) indent = sysindent;
    }
    // cout << "sysrwd: " << sysrwd << ", sysindent: " << sysindent << ", sysscale: " << _bar[0]->scale() << endl;
    for (int i=0; i<_systems; i++) {
      _bar[i]->setRawWidth(rwd);
      _bar[i]->setIndent(indent);
      _bar[i] = (ScoreBar*) tab->next(_bar[i]);
    }
  }

  int width = _editor->editorWidth();
  int sum = 0;
  for (ScoreBar * b = (ScoreBar*) _iterator[0]->operator*(); b!=0; b = (ScoreBar*) tab->next(b)) {
    width -= b->commonIndent();
    sum += b->commonRawWidth();
  }
  double scale = width*1.0/sum;
  // cout << "width: " << width << endl;
  for (int i=0; i<_systems; i++) {
    for (ScoreBar * b = (ScoreBar*) _iterator[i]->operator*(); b!=0; b = (ScoreBar*) tab->next(b)) {
      b->setScale(scale);
      // cout << "scale: " << b->scale() << ", indent: " << b->indent() << endl << endl;
    }
  }

  //
  // adjust meter:
  //
  Part * master = sonG->master();
  if (master != 0) {
    int bar = 0;
    int m0  = 0;
    int m1  = 0;
    int m0_old  = 0;
    int m1_old  = 0;
    int barcount = 0;
    ScoreBar ** bars = new ScoreBar* [_systems];
    for (int i=0; i<_systems; i++) bars[i] = (ScoreBar*) _iterator[i]->operator*();

    for (Event * ev = (Event*) master->first(); ev != 0; ev = (Event*) master->next(ev)) {
      if (ev->isA()==MASTEREVENT && ((MasterEvent*) ev)->tempo()==0) {
	bar = master->start(ev).bar() - 1;
	m0_old = m0;
	m1_old = m1;
	m0  = ((MasterEvent*) ev)->meter0();
	m1  = ((MasterEvent*) ev)->meter1();
	while (barcount < bar) {
	  for (int i=0; i<_systems; i++)
	    if (bars[i]!=0) {
	      if (m0_old != 0) bars[i]->setMeter(m0_old, m1_old);
	      bars[i] = (ScoreBar*) tab->next(bars[i]);
	    }
	  barcount++;
	}
	for (int i=0; i<_systems; i++)
	  if (bars[i]!=0) bars[i]->setMeter(m0,m1);
      }
    }
    delete[] bars;
  }

}


void ScoreIterator::paint() {
  ScoreBar * sb = 0;
  int style = 0; // 0 = center, 1 = top, 2 = bottom, 3 = nothing
  int index = _editor->partIndex();
  for (int i=0; i<_systems; i++) {
    sb = (ScoreBar*) _iterator[i]->operator*();
    _editor->setPart(i);
    if (_systems==1)       style = 3;
    else if (i==0)         style = 1;
    else if (i<_systems-1) style = 0;
    else                   style = 2;
    sb->paint(_editor, _xpos, i*YDELTA, style);
    // cout << *sb << endl;
  }
  if (index==-1) cout << "PANIC!!!" << endl;
  else _editor->setPart(index);
}

void ScoreIterator::print(ostream & out) {
  ScoreBar * sb = (ScoreBar*) _iterator[0]->operator*();

  int met0 = sb->meter(0);
  int met1 = sb->meter(1);
  if (met0>0) {
    out << "score" << endl;
    out << "\ttime = " << met0 << "/" << met1 << endl;
    out << "\tbeamstyle = ";
    for (int i = 0; i < met0; i++) {
      out << met1;
      if (i < met0-1) out << ", ";
    }
    out << endl;
    out << "music" << endl;
  }

  int index = _editor->partIndex();
  int staff = 1;
  //
  // Partiture:
  //
  if (mainEditor->PP())
    for (int i=0; i<_systems; i++) {
      sb = (ScoreBar*) _iterator[i]->operator*();
      _editor->setPart(i);
      if (((ScoreTrack*)_editor->part()->track())->PiP()==true) {
	// out << i+1 << ": ";
	out << staff++ << ": ";
	sb->print(_editor, _xpos, i*100);
	out << endl;
      }
    }
  //
  // Piano System:
  //
  int stafftreb = 1;
  int staffbass = 1;
  int staffsys = 0;
  if (mainEditor->PPS())
    for (int i=0; i<_systems; i++) {
      sb = (ScoreBar*) _iterator[i]->operator*();
      _editor->setPart(i);
      int sys = ((ScoreTrack*)_editor->part()->track())->PiPS(); // 0=skip, 1=treble, 2=bass
      if (sys>0) {
	staffsys = sys==1?(stafftreb++):(staffbass++);
	out << staff+sys-1 << " " << staffsys << ": ";
	sb->print(_editor, _xpos, i*100);
	out << endl;
      }
    }

  if (index==-1) cout << "PANIC!!!" << endl;
  else _editor->setPart(index);
  // out << "bar" << endl;
}

bool ScoreIterator::done() { return _ptr >= _max; }


long ScoreIterator::ticks(int mousex, ScoreArea & area) const {
  long ticks = 0;
  int pos = _xoffset;
  if (mousex < _xoffset) {
    //
    // mousex is even left from the whole score
    //
    area = LeftBorder;
    ticks = 0;

  } else {
    //
    // mousex is somewhere within the score
    //
    Table * tab = new Table();
    ScoreBar * b = 0;
    for (b = _ref_bar[0]; b!=0 && pos + b->width() < mousex; pos += b->width(), b = (ScoreBar*) tab->next(b)) {
      // cout << _xoffset << ", start: " << b->start() << ", in: " << b->indent() << ", sc: " << b->scale() << ", wd: " << b->width() << endl;
    }
    if (b == 0) {
      //
      // mousex is at the very right!
      //
      area = RightBorder;
      ticks = 0;
    } else {
      ticks = mousex - pos - b->xindent();
      if (ticks<=0) {
	//
	// mousex is inside an indent
	//
	ticks = b->start().ticks();
	if (b->isFirst()) area = Clef;
	else              area = Indent;
      } else {
	//
	// mousex is inside the score area
	//
	area = Score;
	// cout << "pix: " << ticks << ", ppt: " << b->unitsPerTick() << ", scale: " << b->scale() << endl;
	ticks = b->start().ticks() + int(ticks*1.0/b->unitsPerTick());
      }
    }
  }
  return ticks;
}

int ScoreIterator::xposition(long ticks) {
  int ret = _xoffset;
  Table * tab = new Table();
  ScoreBar * b = 0;
  for (b = _ref_bar[0]; b!=0 && b->end() < ticks; b = (ScoreBar*) tab->next(b)) {
    ret += b->width();
  }
  if (b!=0) {
    ret += int(b->xindent() + (ticks - b->start().ticks())*b->unitsPerTick());
  }
  return ret;
}

Element * ScoreIterator::operator *() {
  if (_ptr < _max) return _iterator[0]->operator*();
  else return 0;
}

ScoreBar * ScoreIterator::firstBar(int i) const {
  if (i >= _systems) return 0;
  else return _ref_bar[i];
}

Iterator& ScoreIterator::operator++() {
  incr();
  return *this;
}

Iterator ScoreIterator::operator++(int) {
  incr();
  return *this;
}

void ScoreIterator::incr() {
  _ptr++;

  double scale = 0;
  int indent = 0;
  double sysscale = 0;
  int sysindent = 0;
  for (int i=0; i<_systems; i++) {
    sysscale = ((ScoreBar*) _iterator[i]->operator*())->scale();
    sysindent = ((ScoreBar*) _iterator[i]->operator*())->systemIndent();
    if (scale < sysscale) scale = sysscale;
    if (indent < sysindent) indent = sysindent;
  }
  for (int i=0; i<_systems; i++) {
    ((ScoreBar*) _iterator[i]->operator*())->setScale(scale);
    ((ScoreBar*) _iterator[i]->operator*())->setIndent(indent);
  }
  _xpos += ((ScoreBar*) _iterator[0]->operator*())->width();
  // cout << "xpos: " << _xpos << endl;
  for (int i=0; i<_systems; i++)
    _iterator[i]->operator++();
}


#endif
