#ifndef _STEM_CPP_
#define _STEM_CPP_

#include <iostream.h>
#include "stem.h"

Stem::Stem() : _stem(0) { _type = STEM; }

Stem::Stem(const Stem& o) : Ornament(o) {
  _type = STEM;
  _stem = o._stem;
}

void Stem::flip() {
  if (_stem==STEM_UP) _stem = STEM_DOWN;
  else _stem = STEM_UP;
}

void Stem::setDirection(int d) { if (d>=-1 && d<=1)_stem = d; }

void Stem::setUp() { _stem = STEM_UP; }

void Stem::setDown() { _stem = STEM_DOWN; }


// virtuals:


ostream & Stem::print(int dep, ostream & s) const {
  s << spc(dep) << "<STEM value=\"";
  switch (_stem) {
  case STEM_UP: s << "STEM_UP"; break;
  case STEM_DOWN: s << "STEM_DOWN"; break;
  }
  s << "\" />" << endl;
  return s;
}

void Stem::flush(const char * c) const {
  cout << c << "STEM " << _stem << endl;

}

Element * Stem::copy() const {
  return new Stem(*this);
}

#endif
