(**************************************************************************)
(*                   Cameleon                                             *)
(*                                                                        *)
(*      Copyright (C) 2002 Institut National de Recherche en Informatique et   *)
(*      en Automatique. All rights reserved.                              *)
(*                                                                        *)
(*      This program is free software; you can redistribute it and/or modify  *)
(*      it under the terms of the GNU General Public License as published by  *)
(*      the Free Software Foundation; either version 2 of the License, or  *)
(*      any later version.                                                *)
(*                                                                        *)
(*      This program is distributed in the hope that it will be useful,   *)
(*      but WITHOUT ANY WARRANTY; without even the implied warranty of    *)
(*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     *)
(*      GNU General Public License for more details.                      *)
(*                                                                        *)
(*      You should have received a copy of the GNU General Public License  *)
(*      along with this program; if not, write to the Free Software       *)
(*      Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA          *)
(*      02111-1307  USA                                                   *)
(*                                                                        *)
(*      Contact: Maxence.Guesdon@inria.fr                                *)
(**************************************************************************)

(** Management of the custom tool bar. *)

open Cam_types

let (!!) = Options.(!!)

(** Build the tool bar. *)
let build w =
  (match w#children with
    c :: _ -> w#remove c
  | _ -> ());
  let toolbar = GButton.toolbar
      ~border_width: 2
      ~orientation: `HORIZONTAL
      ~button_relief: `NONE
      ~style: `ICONS
      ~packing: w#add ()
  in
  List.iter
    (fun tool ->
      try
	let gdk_pix = GDraw.pixmap_from_xpm 
	    ~file: tool.tool_pixmap 
	    ~colormap: (Gdk.Color.get_system_colormap ())
	    () 
	in
	let pix = GMisc.pixmap gdk_pix () in
	let wb = toolbar#insert_button 
	    ~text: tool.tool_label
	    ~tooltip: tool.tool_label
	    ~icon: pix#coerce
	    ()
	in
	try
	  if Cam_misc.is_internal tool.tool_command then
	    ignore (Hashtbl.find Cam_global.commands tool.tool_command);
	  ignore (wb#connect#clicked (Cam_misc.execute_command tool.tool_command))
	with
	  Not_found ->
	    wb#misc#set_sensitive false
      with
	_ -> ()
    )
    !!Cam_config.custom_tools

