(**************************************************************************)
(*                   Cameleon                                             *)
(*                                                                        *)
(*      Copyright (C) 2002 Institut National de Recherche en Informatique et   *)
(*      en Automatique. All rights reserved.                              *)
(*                                                                        *)
(*      This program is free software; you can redistribute it and/or modify  *)
(*      it under the terms of the GNU General Public License as published by  *)
(*      the Free Software Foundation; either version 2 of the License, or  *)
(*      any later version.                                                *)
(*                                                                        *)
(*      This program is distributed in the hope that it will be useful,   *)
(*      but WITHOUT ANY WARRANTY; without even the implied warranty of    *)
(*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     *)
(*      GNU General Public License for more details.                      *)
(*                                                                        *)
(*      You should have received a copy of the GNU General Public License  *)
(*      along with this program; if not, write to the Free Software       *)
(*      Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA          *)
(*      02111-1307  USA                                                   *)
(*                                                                        *)
(*      Contact: Maxence.Guesdon@inria.fr                                *)
(**************************************************************************)

(** Pre-defined commands. *)

(** Make the user choose a file type (among those defined) and a name, 
   and create the file, using the templates of the file type. 
   Then perform [cvs add] on the file, and uses the associated editor
   to edit the new file.
   If files are given in arguments, then use the file names
   to get the templates to use, create the files using the templates
   and add them to the CVS repository. The given filenames are concatenated
   to the current selected directory, if any.
   @command new_file *)
let new_file args =
  match args with
    [] ->
      Cam_new_file.popup 0 0 
	!Cam_global.selected_dir
	(Cam_global.exec Cam_messages.a_update_files_view [])
  | l ->
      match !Cam_global.selected_dir () with
	None ->
	  !Cam_global.display_message
	    Cam_messages.select_a_directory_first
      |	Some d ->
	  Cam_new_file.create_file_list d l
	    (Cam_global.exec Cam_messages.a_update_files_view [])
