(**************************************************************************)
(*                   Cameleon                                             *)
(*                                                                        *)
(*      Copyright (C) 2002 Institut National de Recherche en Informatique et   *)
(*      en Automatique. All rights reserved.                              *)
(*                                                                        *)
(*      This program is free software; you can redistribute it and/or modify  *)
(*      it under the terms of the GNU General Public License as published by  *)
(*      the Free Software Foundation; either version 2 of the License, or  *)
(*      any later version.                                                *)
(*                                                                        *)
(*      This program is distributed in the hope that it will be useful,   *)
(*      but WITHOUT ANY WARRANTY; without even the implied warranty of    *)
(*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     *)
(*      GNU General Public License for more details.                      *)
(*                                                                        *)
(*      You should have received a copy of the GNU General Public License  *)
(*      along with this program; if not, write to the Free Software       *)
(*      Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA          *)
(*      02111-1307  USA                                                   *)
(*                                                                        *)
(*      Contact: Maxence.Guesdon@inria.fr                                *)
(**************************************************************************)

class dbforge_app file =
  let data = new Dbf_data.data 
      [Dbf_odbc.spec ; Dbf_mysql.spec ; Dbf_postgres.spec] file in
  let gui = new Dbf_gui.gui data in
  
  object (self)
    method box = gui#box
    method close = gui#box#destroy ()
    method reload =
      (
       try
         data#load ;
       with Failure s -> 
         GToolbox.message_box Dbf_messages.error s
      );
      gui#update
    method save = gui#save
    method changed = data#changed
    method init_window = gui#init_window

  end
