(**************************************************************************)
(*                   Cameleon                                             *)
(*                                                                        *)
(*      Copyright (C) 2002 Institut National de Recherche en Informatique et   *)
(*      en Automatique. All rights reserved.                              *)
(*                                                                        *)
(*      This program is free software; you can redistribute it and/or modify  *)
(*      it under the terms of the GNU General Public License as published by  *)
(*      the Free Software Foundation; either version 2 of the License, or  *)
(*      any later version.                                                *)
(*                                                                        *)
(*      This program is distributed in the hope that it will be useful,   *)
(*      but WITHOUT ANY WARRANTY; without even the implied warranty of    *)
(*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     *)
(*      GNU General Public License for more details.                      *)
(*                                                                        *)
(*      You should have received a copy of the GNU General Public License  *)
(*      along with this program; if not, write to the Free Software       *)
(*      Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA          *)
(*      02111-1307  USA                                                   *)
(*                                                                        *)
(*      Contact: Maxence.Guesdon@inria.fr                                *)
(**************************************************************************)

(** Generic classes for LablGtk. *)

(** {2 Lists} *)

type content =
  | String of string 
  | Pixmap of GDraw.pixmap

class virtual ['a] plist : 
    Gtk.Tags.selection_mode ->
      string list ->
	bool ->
  object
    val mutable data : 'a list
    val mutable selection : 'a list
    val mutable current_sort : int
    method box : GObj.widget
    method wlist : 'a GList.clist
    method update_row : 'a -> int -> unit
    method insert : ?row: int -> 'a -> unit
    method update_data : 'a list -> unit
    method update : unit
    method virtual content : 'a -> content list * GDraw.optcolor option
    method virtual compare : 'a -> 'a -> int
    method selection : 'a list
    method set_titles : string list -> unit
    method on_select : 'a -> unit
    method on_deselect : 'a -> unit
    method on_double_click : 'a -> unit
    method menu : GToolbox.menu_entry list
  end
