(**************************************************************************)
(*                   Cameleon                                             *)
(*                                                                        *)
(*      Copyright (C) 2002 Institut National de Recherche en Informatique et   *)
(*      en Automatique. All rights reserved.                              *)
(*                                                                        *)
(*      This program is free software; you can redistribute it and/or modify  *)
(*      it under the terms of the GNU General Public License as published by  *)
(*      the Free Software Foundation; either version 2 of the License, or  *)
(*      any later version.                                                *)
(*                                                                        *)
(*      This program is distributed in the hope that it will be useful,   *)
(*      but WITHOUT ANY WARRANTY; without even the implied warranty of    *)
(*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     *)
(*      GNU General Public License for more details.                      *)
(*                                                                        *)
(*      You should have received a copy of the GNU General Public License  *)
(*      along with this program; if not, write to the Free Software       *)
(*      Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA          *)
(*      02111-1307  USA                                                   *)
(*                                                                        *)
(*      Contact: Maxence.Guesdon@inria.fr                                *)
(**************************************************************************)

(** The MLChat library. You can use it to add chat in your apps.*)

type port = int
type host = string
type id = string

(** {2 Configuration}*)

(** The type of the class to use as the st of options. *)
class type config = 
  object
    method args_spec : (string * Arg.spec * string) list
    method color_connected : string
    method color_connected_temp : string
    method color_myself : string
    method color_not_connected : string
    method dialog_buttons : bool
    method id : string
    method people : (string * string * int) list
    method popup_all : bool
    method port : int
    method save : unit
    method set_color_connected : string -> unit
    method set_color_connected_temp : string -> unit
    method set_color_myself : string -> unit
    method set_color_not_connected : string -> unit
    method set_dialog_buttons : bool -> unit
    method set_id : string -> unit
    method set_people : (id * host * port) list -> unit
    method set_popup_all : bool -> unit
    method set_port : int -> unit
    method set_timeout : int -> unit
    method timeout : int
    method set_send_timeout : int -> unit
    method send_timeout : int
    method second_send_timeout : float

  end

(** Create a config object from a config file name.
   Options are saved in this file. *)
class file_config : string -> config


(** {2 Communication} *)

type address = host * port
type message = string
type version
type source = version * id * address
type proto = 
    Hello | HelloOk | Byebye | Message of message
  | AddOpen of id * address
  | RoomMessage of id * (id * host * port) list * message
  | File of int * string
type info = source * id * proto

val version : unit -> version

(** Read a info from the given buffer. *)
val read_info : Buffer.t -> info

(** Read a info from the given channel. *)
val read_info_channel : in_channel -> info

(** Write the given info to the given buffer. *)
val write_info : Buffer.t -> info -> unit

(** Write the given info to the given channel. *)
val write_info_channel : out_channel -> info -> unit


