(**************************************************************************)
(*                   Cameleon                                             *)
(*                                                                        *)
(*      Copyright (C) 2002 Institut National de Recherche en Informatique et   *)
(*      en Automatique. All rights reserved.                              *)
(*                                                                        *)
(*      This program is free software; you can redistribute it and/or modify  *)
(*      it under the terms of the GNU General Public License as published by  *)
(*      the Free Software Foundation; either version 2 of the License, or  *)
(*      any later version.                                                *)
(*                                                                        *)
(*      This program is distributed in the hope that it will be useful,   *)
(*      but WITHOUT ANY WARRANTY; without even the implied warranty of    *)
(*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     *)
(*      GNU General Public License for more details.                      *)
(*                                                                        *)
(*      You should have received a copy of the GNU General Public License  *)
(*      along with this program; if not, write to the Free Software       *)
(*      Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA          *)
(*      02111-1307  USA                                                   *)
(*                                                                        *)
(*      Contact: Maxence.Guesdon@inria.fr                                *)
(**************************************************************************)

open Options

module O = Options
module R = Omom_rc

let eval_function = ref (function (x : string) -> x)
let eval x = !eval_function x

let string_of_char c = String.make 1 c
let concat char string =
  string_of_char char ^ string

let rec parse_var = parser
  | [< '')' >] -> ""
  | [< 'v; ar = parse_var >] ->
      concat v ar
  | [< >] ->
      failwith "parse_var"

let rec parse_var_or_not = parser
  | [< ''('; v = parse_var >] -> 
      parse_file (Stream.of_string (eval v))
  | [< >] ->
      print_char '!'
and parse_file = parser
  | [< ''!'; stream >] ->
      parse_var_or_not stream;
      parse_file stream
  | [< 'c; stream >] ->
      print_char c;
      parse_file stream
  | [< >] ->
      ()

exception Parse_error of string

let gen_make file f =
  eval_function := f;
  let file_in = open_in (Omom_expand_path.expand_path file) in
    (try
       parse_file (Stream.of_channel file_in)
     with 
       | Stream.Failure ->
	   raise (Parse_error "")
       | Stream.Error s ->
	   raise (Parse_error s));
    flush stdout

