/*  File: main.c
 *
 * Copyright (C) 2000-2003 Christopher R. Gabriel <cgabriel@cgabriel.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or 
 * (at your option) any later version. 
 *
 */

#include <gconf/gconf-client.h>
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>

GtkWidget *window, *label, *progress;
gint timeout;
GdkPixbuf *desktop;
GdkPixmap *pixmap;
gint val = 0;
gint mesg1 = 0, mesg2 = 1;
gchar *messages[6];


#define GET_COLOR(r, g, b, a) ((((int) (r) & 0xff) << 24)    \
                                          | (((int) (g) & 0xff) << 16)  \
                                          | (((int) (b) & 0xff) << 8)   \
                                          | ((int) (a) & 0xff))

gint
update_all(gpointer data)
{

  gchar * str;

  if(val&1) {
  gdk_pixbuf_fill(desktop,GET_COLOR(val/2,val/3,val,val));
  
  pixmap = gdk_pixmap_new(GTK_WIDGET(window)->window,
						  gdk_screen_width(),
						  gdk_screen_height(),
						  -1);
  
  gdk_pixbuf_render_to_drawable_alpha(desktop,
									  pixmap,
									  0,
									  0,
									  0,
									  0,
									  gdk_screen_width(),
									  gdk_screen_height(),
									  GDK_PIXBUF_ALPHA_BILEVEL,
									  0,
									  GDK_RGB_DITHER_NONE,
									  0,
									  0);
  
  gdk_window_set_back_pixmap(GTK_WIDGET(window)->window, pixmap, FALSE);
  gdk_pixmap_unref(pixmap);
  
  gtk_widget_queue_draw(window);
  }
  if(val <= 99) {
	val = val + 1;
  } else {
	mesg1++;
	val = 0;
  }


  if(mesg1 == 5)
	{
	  mesg1=0;
	  mesg2++;
	}

  if(mesg2 == 11)
	{
	  mesg2 = 1;
	}

  str = g_strdup_printf("<span foreground=\"white\" size=\"x-large\"><b>%s module #%d</b></span>",
						messages[mesg1], mesg2);

  gtk_label_set_markup(GTK_LABEL(label), str);

  
  str = g_strdup_printf("%d %%", val);
  gtk_progress_bar_set_text(GTK_PROGRESS_BAR(progress), str);

  g_free(str);

  gtk_progress_set_value(GTK_PROGRESS(progress), val);
  
  return TRUE;
}

static void
exit_cb(GtkWidget *widget, gpointer data)
{
  gtk_timeout_remove(timeout);
  gtk_main_quit();
}


static gint
key_press(GtkWidget *widget, GdkEvent *e)
{


  if(((GdkEventKey)(e->key)).keyval == GDK_Escape) {
	exit_cb(widget, NULL);
	return TRUE;
  }

  return FALSE;

}


int
main(int argc, char **argv)
{
  GConfClient *client;
  GtkWidget *hbox, *frame, *align, *vbox;
  GtkWidget *tlabel;

  gtk_init(&argc, &argv);


    
  client = gconf_client_get_default();

  gconf_client_add_dir (client, "/apps/cappuccino",
                        GCONF_CLIENT_PRELOAD_NONE, NULL);

  
  messages[0] = gconf_client_get_string(client, "/apps/cappuccino/operation0", NULL);

  if(messages[0] == NULL) {
	messages[0] = g_strdup_printf("%s", "COMPILING");
	gconf_client_set_string(client, "/apps/cappuccino/operation0", "COMPILING", NULL);
  }

  messages[1] = gconf_client_get_string(client, "/apps/cappuccino/operation1", NULL);

  if(messages[1] == NULL) {
	messages[1] = g_strdup_printf("%s", "STRIPPING");
	gconf_client_set_string(client, "/apps/cappuccino/operation1", "STRIPPING", NULL);
  }

  messages[2] = gconf_client_get_string(client, "/apps/cappuccino/operation2", NULL);

  if(messages[2] == NULL){
	messages[2] = g_strdup_printf("%s", "LINKING");
	gconf_client_set_string(client, "/apps/cappuccino/operation2", "LINKING", NULL);
  }

  messages[3] = gconf_client_get_string(client, "/apps/cappuccino/operation3", NULL);

  if(messages[3] == NULL)
	{
	  messages[3] = g_strdup_printf("%s", "PROCESSING");
	  gconf_client_set_string(client, "/apps/cappuccino/operation3", "PROCESSING", NULL);
	}

  messages[4] = gconf_client_get_string(client, "/apps/cappuccino/operation4", NULL);

  if(messages[4] == NULL) {
	messages[4] = g_strdup_printf("%s", "VERIFYING");
	gconf_client_set_string(client, "/apps/cappuccino/operation4", "VERIFYING", NULL);
  }

  messages[5] = gconf_client_get_string(client, "/apps/cappuccino/operation5", NULL);

  if(messages[5] == NULL) {
 	messages[5] = g_strdup_printf("%s", "INSTALLING");
	gconf_client_set_string(client, "/apps/cappuccino/operation5", "INSTALLING", NULL);
  }

  window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  
  g_signal_connect(G_OBJECT(window), "key_press_event",
				   G_CALLBACK(key_press), NULL);

  g_signal_connect(G_OBJECT(window), "delete_event",
				   G_CALLBACK(exit_cb), NULL);

  g_signal_connect(G_OBJECT(window), "destroy",
				   G_CALLBACK(exit_cb), NULL);

  gtk_window_set_default_size(GTK_WINDOW(window),
							  gdk_screen_width(),
							  gdk_screen_height());
  
  gtk_widget_set_app_paintable(GTK_WIDGET(window), TRUE);
  gtk_widget_realize(GTK_WIDGET(window));
  
  desktop = gdk_pixbuf_get_from_drawable(NULL,
										 gdk_get_default_root_window(),
										 gdk_colormap_get_system(),
										 0,
										 0,
										 0,
										 0,
										 gdk_screen_width(),
										 gdk_screen_height());
  
  pixmap = gdk_pixmap_new(GTK_WIDGET(window)->window,
						  gdk_screen_width(),
						  gdk_screen_height(),
						  -1);
  
  gdk_pixbuf_fill(desktop,0x000000);
  
  
  gdk_pixbuf_render_to_drawable_alpha(desktop,
									  pixmap,
									  0,
									  0,
									  0,
									  0,
									  gdk_screen_width(),
									  gdk_screen_height(),
									  GDK_PIXBUF_ALPHA_BILEVEL,
									  0,
									  GDK_RGB_DITHER_NONE,
									  0,
									  0);
  
  gdk_window_set_back_pixmap(GTK_WIDGET(window)->window, pixmap, FALSE);
  
  gdk_pixmap_unref(pixmap);
  frame = gtk_frame_new(NULL);
  gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_NONE);
  gtk_widget_show(frame);
 
  align = gtk_alignment_new(0.5, 0.5, 0.8, 0.0);
  gtk_widget_show(align);
  gtk_container_add(GTK_CONTAINER(window), align); 

  vbox = gtk_vbox_new(FALSE,0);
  gtk_widget_show(vbox);
 
  gtk_container_add(GTK_CONTAINER(align), frame);
  gtk_container_add(GTK_CONTAINER(frame), vbox);
 
  label = gtk_label_new(NULL);
  gtk_widget_show(label);
 
  gtk_box_pack_start(GTK_BOX(vbox), label, FALSE, FALSE, 12);
 
  hbox = gtk_hbox_new(FALSE,0);
  gtk_widget_show(hbox);
  gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, FALSE, 0);
 
  progress = gtk_progress_bar_new();
  gtk_progress_set_value(GTK_PROGRESS(progress), 0.1);
  gtk_widget_show(progress);
  gtk_box_pack_start(GTK_BOX(hbox), progress, TRUE, TRUE, 8);

  tlabel = gtk_label_new(NULL);
  gtk_widget_show(tlabel);
  gtk_label_set_markup(GTK_LABEL(tlabel), "<span foreground=\"white\"><b>Work in progress, please wait...</b></span>");

  gtk_box_pack_start(GTK_BOX(vbox), tlabel, FALSE, FALSE, 12);

 
  gtk_window_stick(GTK_WINDOW(window)); 
  gtk_window_set_decorated(GTK_WINDOW(window), FALSE);
  
  gtk_widget_show(GTK_WIDGET(window));
  
  timeout = gtk_timeout_add(400, update_all, NULL);

  gtk_main();

  g_object_unref(client);
  gdk_pixbuf_unref(desktop);

  g_free(messages[0]);
  g_free(messages[1]);
  g_free(messages[2]);
  g_free(messages[3]);
  g_free(messages[4]);
  g_free(messages[5]);
  return 0;

}
