/*
 * dbCommon.m
 *
 * Copyright 1996-1999 by vhf interservice GmbH
 * Author:   Georg Fleischmann
 *
 * created:  11.09.96
 * modified: 08.01.97 23.05.97 05.01.98
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <limits.h>
#include "dbCommon.h"

#define STATEARRAY_CNT	1

//static StateCoord StateArray[] = { {49, {142, 125, 8.8167, 53.0833}, {263, 439, 11.5667, 48.1333}}, /* Bremen, Munich */
//                                   {0, {0, 0, 0.0, 0.0}, {0, 0, 0.0, 0.0}} };
static StateCoord StateArray[] = { {49, {138, 118, 8.8167, 53.0833}, {259, 433, 11.5667, 48.1333}}, /* Bremen, Munich */
                                   {0, {0, 0, 0.0, 0.0}, {0, 0, 0.0, 0.0}} };

/* replace all apearances of 'from' with 'to' in 'string'
 * if we get a mutable string we modify in place
 *
 * created:  18.02.97
 * modified: 31.05.97 14.07.97 05.01.98
 */
id replaceSubString(id string, NSString *from, NSString *to)
{   NSRange		range, searchRange;
    NSMutableString	*mutString = [NSMutableString string];
    int			start = 0;

    searchRange = NSMakeRange(0, [string length]);
    while( searchRange.length )
    {
        range = [string rangeOfString:from options:0/*NSCaseInsensitiveSearch*/ range:searchRange];
        if( !range.length )
            break;
#if 0
        if( [string isKindOfClass:[NSMutableString class]] )
            [string replaceCharactersInRange:range withString:to];
        else
            string = [NSString stringWithFormat:@"%@%@%@", [string substringToIndex:range.location], to, [string substringFromIndex:range.location+range.length]];
#endif
        [mutString appendString:[string substringWithRange:NSMakeRange(start, range.location-start)]];
        [mutString appendString:to];

        start = searchRange.location = range.location+[from length];
        searchRange.length = [string length] - searchRange.location;
    }
    [mutString appendString:[string substringFromIndex:start]];
    if( [string isKindOfClass:[NSMutableString class]] )
        [string setString:mutString];
    else
        string = mutString;

    return string;
}

/* replace all apearances in 'from' with 'to' in 'string'
 * if we get a mutable string we modify in place
 *
 * we sort in a 2nd string because replaceCharactersInRange is much too slow
 *
 * created:  30.05.97
 * modified: 
 */
id replaceSubStrings(id string, NSArray *fromA, NSArray *toA)
{   NSRange		range, searchRange;
    NSCharacterSet	*fromCharSet;
    NSMutableString	*mutString = [NSMutableString string];
    NSString		*from = nil, *to = nil;
    int			i, cnt, start = 0;

    if( !string )
        return nil;
    for( i=0, cnt=[fromA count]; i<cnt; i++ )
        [mutString appendString:[[fromA objectAtIndex:i] substringToIndex:1]];
    fromCharSet = [NSCharacterSet characterSetWithCharactersInString:mutString];

    mutString = [NSMutableString string];
    searchRange = NSMakeRange(0, [string length]);
    while(1)
    {
        range = [string rangeOfCharacterFromSet:fromCharSet options:0 range:searchRange];
        if( !range.length )
            break;
        to = nil;
        for( i=0, cnt=[fromA count]; i<cnt; i++ )
        {   from = [fromA objectAtIndex:i];
            range.length = [from length];
            if( [string compare:from options:0 range:range] == NSOrderedSame )
            {   to = [toA objectAtIndex:i];
                break;
            }
        }
        if( !to )
        {   searchRange.location = range.location+1;
            searchRange.length = [string length] - searchRange.location;
            continue;
        }
        [mutString appendString:[string substringWithRange:NSMakeRange(start, range.location-start)]];
        [mutString appendString:to];

        start = searchRange.location = range.location+[from length];
        searchRange.length = [string length] - searchRange.location;
    }
    [mutString appendString:[string substringFromIndex:start]];
    [string setString:mutString];

    return string;
}

NSString *convertUmlautToHTML(NSString *data)
{   unsigned char	*oldData, *newData;
    int			i, j=0;
    int			len;

    len = [data cStringLength];
    if(!(oldData = malloc(len+1)))
        return data;
    [data getCString:oldData];
    if(!(newData = malloc(len*6l+1)))
        return data;
    for(i=0; i<len; i++)
    {
        switch(oldData[i])
        {
            case 0:
                continue;
            case '\r':
                continue;
            case 0260:	/* reg */
                strcpy(newData+j, "&reg;"); j+=strlen("&reg;");
                break;
            case 0366:	/* '' */
                strcpy(newData+j, "&uuml;"); j+=strlen("&uuml;");
                break;
            case 0232:	/* '' */
                strcpy(newData+j, "&Uuml;"); j+=strlen("&Uuml;");
                break;
            case 0360:	/* '', 0xf0 */
                strcpy(newData+j, "&ouml;"); j+=strlen("&ouml;");
                break;
            case 0226:	/* '' */
                strcpy(newData+j, "&Ouml;"); j+=strlen("&Ouml;");
                break;
            case 0373:	/* '' */
                strcpy(newData+j, "&szlig;"); j+=strlen("&szlig;");
                break;
            case 0247:	/* '' */
                strcpy(newData+j, "&sect;"); j+=strlen("&sect;");
                break;
            case 0312:	/* degree */
                strcpy(newData+j, "&deg;"); j+=strlen("&deg;");
                break;
            case 0240:	/* Alt-c (c) */
                strcpy(newData+j, "&copy;"); j+=strlen("&copy;");
                break;
            case 0331:	/* '' */
                strcpy(newData+j, "&auml;"); j+=strlen("&auml;");
                break;
            case 0205:	/* '' */
                strcpy(newData+j, "&Auml;"); j+=strlen("&Auml;");
                break;
            case 0332:	/* aring */
                strcpy(newData+j, "&aring;"); j+=strlen("&aring;");
                break;
            case 0206: /* Aring */
                strcpy(newData+j, "&Aring;"); j+=strlen("&Aring;");
                break;
            case 0326:	/* aacute */
                strcpy(newData+j, "&aacute;"); j+=strlen("&aacute;");
                break;
            case 0202:	/* Aacute */
                strcpy(newData+j, "&Aacute;"); j+=strlen("&Aacute;");
                break;
            case 0327:	/* acircumflex */
                strcpy(newData+j, "&acirc;"); j+=strlen("&acirc;");
                break;
            case 0203:	/* Acircumflex */
                strcpy(newData+j, "&Acirc;"); j+=strlen("&Acirc;");
                break;
            case 0325:	/* agrave */
                strcpy(newData+j, "&agrave;"); j+=strlen("&agrave;");
                break;
            case 0201:	/* Agrave */
                strcpy(newData+j, "&Agrave;"); j+=strlen("&Agrave;");
                break;
            case 0333:	/* ccedilla */
                strcpy(newData+j, "&ccedil;"); j+=strlen("&ccedil;");
                break;
            case 0207:	/* Ccedilla */
                strcpy(newData+j, "&Ccedil;"); j+=strlen("&Ccedil;");
                break;
            case 0335:	/* eacute */
                strcpy(newData+j, "&eacute;"); j+=strlen("&eacute;");
                break;
            case 0211:	/* Eacute */
                strcpy(newData+j, "&Eacute;"); j+=strlen("&Eacute;");
                break;
            case 0336:	/* ecircumflex */
                strcpy(newData+j, "&ecirc;"); j+=strlen("&ecirc;");
                break;
            case 0212:	/* Ecircumflex */
                strcpy(newData+j, "&Ecirc;"); j+=strlen("&Ecirc;");
                break;
            case 0337:	/* edieresis */
                strcpy(newData+j, "&euml;"); j+=strlen("&euml;");
                break;
            case 0213:	/* Edieresis */
                strcpy(newData+j, "&Euml;"); j+=strlen("&Euml;");
                break;
            case 0334:	/* egrave */
                strcpy(newData+j, "&egrave;"); j+=strlen("&egrave;");
                break;
            case 0210:	/* Egrave */
                strcpy(newData+j, "&Egrave;"); j+=strlen("&Egrave;");
                break;
            case 0342:	/* iacute */
                strcpy(newData+j, "&iacute;"); j+=strlen("&iacute;");
                break;
            case 0215:	/* Iacute */
                strcpy(newData+j, "&Iacute;"); j+=strlen("&Iacute;");
                break;
            case 0344:	/* icircumflex */
                strcpy(newData+j, "&icirc;"); j+=strlen("&icirc;");
                break;
            case 0216:	/* Icircumflex */
                strcpy(newData+j, "&Icirc;"); j+=strlen("&Icirc;");
                break;
            case 0345:	/* idieresis */
                strcpy(newData+j, "&iuml;"); j+=strlen("&iuml;");
                break;
            case 0217:	/* Idieresis */
                strcpy(newData+j, "&Iuml;"); j+=strlen("&Iuml;");
                break;
            case 0340:	/* igrave */
                strcpy(newData+j, "&igrave;"); j+=strlen("&igrave;");
                break;
            case 0214:	/* Igrave */
                strcpy(newData+j, "&Igrave;"); j+=strlen("&Igrave;");
                break;
            case 0371: /* oslash */
                strcpy(newData+j, "&oslash;"); j+=strlen("&oslash;");
                break;
            case 0351: /* Oslash */
                strcpy(newData+j, "&Oslash;"); j+=strlen("&Oslash;");
                break;
            case 042:	/* quote */
                strcpy(newData+j, "&quot;"); j+=strlen("&quot;");
                break;
            default:
                newData[j++] = oldData[i];
        }
    }
    newData[j++] = 0;
    data = [NSString stringWithCString:newData];
    free(newData);
    return data;
}

NSString *convertUmlautFromHTML(NSString *data)
{   int			i;
    int			len;
    unsigned char	*newData;

    if( !data )
        return nil;
    len = [data cStringLength];
    if(!(newData = malloc(len+1)))
        return data;
    [data getCString:newData];
    for(i=0; i<len; i++)
    {
        switch(newData[i])
        {
            case 0:
                continue;
            case '\r':
                continue;
            case 0xfc:	/* uuml */
                newData[i] = '';
                break;
            case 0xdc:	/* Uuml */
                newData[i] = '';
                break;
            case 0xf6:	/* ouml */
                newData[i] = '';
                break;
            case 0xd6:	/* Ouml */
                newData[i] = '';
                break;
            case 0xe4:	/* auml */
                newData[i] = '';
                break;
            case 0xc4:	/* Auml */
                newData[i] = '';
                break;
            case 0xdf:	/* szlig */
                newData[i] = '';
                break;
            case 167:	/*  */
                newData[i] = '';
                break;
            case 38:	/* & */
                newData[i] = '&';
                break;
            case 0x25:	/* % */
                newData[i] = '%';
                break;
            case 248:	/* oslash */
                newData[i] = '';
                break;
            case 216:	/* Oslash */
                newData[i] = '';
                break;
            case 174:	/* reg, registered trademark */
                newData[i] = 0260;
                break;
            case 229:	/* aring */
                newData[i] = '';
                break;
            case 197: /* Aring */
                newData[i] = '';
                break;
            case 225:	/* aacute */
                newData[i] = '';
                break;
            case 193:	/* Aacute */
                newData[i] = '';
                break;
            case 226:	/* acircumflex */
                newData[i] = '';
                break;
            case 194:	/* Acircumflex */
                newData[i] = '';
                break;
            case 224:	/* agrave */
                newData[i] = '';
                break;
            case 192:	/* Agrave */
                newData[i] = '';
                break;
            case 231:	/* ccecilla */
                newData[i] = '';
                break;
            case 199:	/* Ccedilla */
                newData[i] = '';
                break;
            case 233:	/* eacute */
                newData[i] = '';
                break;
            case 201:	/* Eacute */
                newData[i] = '';
                break;
            case 234:	/* ecircumflex */
                newData[i] = '';
                break;
            case 202:	/* Ecircumflex */
                newData[i] = '';
                break;
            case 232:	/* egrave */
                newData[i] = '';
                break;
            case 200:	/* Egrave */
                newData[i] = '';
                break;
            case 237:	/* iacute */
                newData[i] = '';
                break;
            case 205:	/* Iacute */
                newData[i] = '';
                break;
            case 238:	/* icircumflex */
                newData[i] = '';
                break;
            case 206:	/* Icircumflex */
                newData[i] = '';
                break;
            case 204:	/* igrave */
                newData[i] = '';
                break;
            case 236:	/* Igrave */
                newData[i] = '';
                break;
            case 218:	/* ? */
            case 186:	/* ordm */
            case 176:	/* deg */
                newData[i] = 0312;
                break;
            default:
                ;
        }
    }
    data = [NSString stringWithCString:newData];
    free(newData);
    return data;
}

BOOL pixelToDegree(int xPixel, int yPixel, int stateId, float *longitude, float *latitude)
{	long	i;
	float	city1_x = 9999.0, city1_y = 0, city1_long = 0, city1_lat = 0, city2_x = 0, city2_y = 0, city2_long = 0, city2_lat = 0;

	/* search cities with stateId from StateArray
	 */
	for(i=0; i<STATEARRAY_CNT; i++)
	{
		if( stateId == StateArray[i].stateId )
		{
			city1_x = (float)StateArray[i].city1.xPixel;
			city1_y = (float)StateArray[i].city1.yPixel;
			city1_long = StateArray[i].city1.longitude;
			city1_lat = StateArray[i].city1.latitude;
			city2_x = (float)StateArray[i].city2.xPixel;
			city2_y = (float)StateArray[i].city2.yPixel;
			city2_long = StateArray[i].city2.longitude;
			city2_lat = StateArray[i].city2.latitude;
			break;
		}
	}
	if( city1_x == 9999 )
		return NO;

	/* calc longitude/latitude
	 *
	 * (newPixelvalue - city1) / (difference city2 - city1) = newDifferenceInDegree / (city2Deg-city1Deg)
	 * -> newDifferenceInDegree = (city2 - newPixelvalue) / (difference city2 - city1) * (city2Deg-city1Deg)
	 * newDifferenceInDegree + city2Deg -> our new grade value
	 */
	*longitude = ((xPixel - city1_x) / (city2_x - city1_x) * (city2_long - city1_long)) + city1_long;
	*latitude = ((yPixel - city1_y) / (city2_y - city1_y) * (city2_lat - city1_lat)) + city1_lat;

	return YES;
}

/* created: 13.11.96
 *
 * used in switch entries of a form
 * loc_2000
 * str = "loc_", i = 0x2000
 */
const char *buildSwitch(const char *str, int i)
{	static char string[1024];

	sprintf(string, "%s%x", str, i);
	return string;
}
