;;; learning/domains/restaurant-boolean.lisp
;;; Restaurant learning problem encoded using boolean attributes only,
;;; as appropriate for decision-list learning.
;;; Target is encoded as a decision list.

(defvar *restaurant-boolean* 
  '(		 (0 ((patrons 1 0) . 0))
		 (1 ((full 1 0) . 0))
		 (0 ((>30 1 0) . 1))
		 (1 ((wait 1 0) . 0))
		 (1 ((>10 1 0) . 0) ((hungry 1 0) . 0))
		 (1 ((>10 1 0) . 0) ((hungry 1 0) . 1) ((alternate 1 0) . 0))
		 (0 ((>10 1 0) . 0) ((hungry 1 0) . 1) ((alternate 1 0) . 1) ((raining 1 0) . 0))
		 (1 ((>10 1 0) . 0) ((hungry 1 0) . 1) ((alternate 1 0) . 1) ((raining 1 0) . 1))
		 (0 ((>10 1 0) . 1) ((alternate 1 0) . 1) ((fri/sat 1 0) . 0))
		 (1 ((>10 1 0) . 1) ((alternate 1 0) . 1) ((fri/sat 1 0) . 1))
		 (0 ((>10 1 0) . 1) ((alternate 1 0) . 0) ((reservation 1 0) . 0) ((bar 1 0) . 0))
		 (1 ((>10 1 0) . 1) ((alternate 1 0) . 0) ((reservation 1 0) . 0) ((bar 1 0) . 1))
		 (1)))



(defvar *restaurant-boolean-problem*)

(setq *restaurant-boolean-problem*
      (make-learning-problem
       :attributes '((alternate 1 0)
		     (bar 1 0)
		     (fri/sat 1 0)
		     (hungry 1 0)
		     (patrons 1 0) ;; none some full 0 0.5 1
		     (full 1 0)
		     (cheap 1 0)
		     (expensive 1 0)
		     (raining 1 0)
		     (reservation 1 0)
		     (french 1 0)
		     (italian 1 0)
		     (thai 1 0)
		     (burger 1 0)
		     (wait 1 0)
		     (>10 1 0)
		     (>30 1 0))
       :goals      '((willwait 1 0))
       :examples   '(((willwait . 1) (alternate . 1) (bar . 0) (fri/sat . 0) 
		      (hungry . 1) (patrons . 0.5) (price . 1) (raining . 0) 
		      (reservation . 1) (type . 1)  (waitestimate . 0)  )
		     ((willwait . 0) (alternate . 1) (bar . 0) (fri/sat . 0) 
		      (hungry . 1) (patrons . 1) (price . 0) (raining . 0) 
		      (reservation . 0) (type . 0.33)  (waitestimate . 0.5)  )
		     ((willwait . 1) (alternate . 0) (bar . 1) (fri/sat . 0) 
		      (hungry . 0) (patrons . 0.5) (price . 0) (raining . 0) 
		      (reservation . 0) (type . 0)  (waitestimate . 0)  )
		     ((willwait . 1) (alternate . 1) (bar . 0) (fri/sat . 1) 
		      (hungry . 1) (patrons . 1) (price . 0) (raining . 0) 
		      (reservation . 0) (type . 0.33)  (waitestimate . 0.17)  )
		     ((willwait . 0) (alternate . 1) (bar . 0) (fri/sat . 1)  
		      (hungry . 0) (patrons . 1) (price . 1) (raining . 0) 
		      (reservation . 1) (type . 1)  (waitestimate . 1)  )
		     ((willwait . 1) (alternate . 0) (bar . 1) (fri/sat . 0) 
		      (hungry . 1) (patrons . 0.5) (price . 0.5) (raining . 1) 
		      (reservation . 1)  (type . 0.67)  (waitestimate . 0)  )
		     ((willwait . 0) (alternate . 0) (bar . 1) (fri/sat . 0) 
		      (hungry . 0) (patrons . 0) (price . 0) (raining . 1) 
		      (reservation . 0) (type . 0)  (waitestimate . 0)  )
		     ((willwait . 1) (alternate . 0) (bar . 0) (fri/sat . 0) 
		      (hungry . 1) (patrons . 0.5) (price . 0.5) (raining . 1) 
		      (reservation . 1) (type . 0.33)  (waitestimate . 0)  )
		     ((willwait . 0) (alternate . 0) (bar . 1) (fri/sat . 1) 
		      (hungry . 0) (patrons . 1) (price . 0) (raining . 1)  
		      (reservation . 0) (type . 0)  (waitestimate . 1)  )
		     ((willwait . 0) (alternate . 1) (bar . 1) (fri/sat . 1) 
		      (hungry . 1) (patrons . 1) (price . 1) (raining . 0) 
		      (reservation . 1) (type . 0.67)  (waitestimate . 0.17)  )
		     ((willwait . 0) (alternate . 0) (bar . 0) (fri/sat . 0) 
		      (hungry . 0) (patrons . 0) (price . 0) (raining . 0) 
		      (reservation . 0) (type . 0.33)  (waitestimate . 0)  )
		     ((willwait . 1) (alternate . 1) (bar . 1) (fri/sat . 1) 
		      (hungry . 1) (patrons . 1) (price . 0) (raining . 0) 
		      (reservation . 0) (type . 0)  (waitestimate . 0.5)  )
		     )))

