;;; -*- Syntax: Ansi-Common-Lisp; Base: 10; Mode: lisp; Package: odcl -*-
;;; $Id: conditions.lisp,v 1.5 2003/03/24 21:51:31 adam Exp $
;;;
;;; Copyright (c) 1999 - 2003 onShore Development, Inc.

(in-package :odcl)

(define-condition property-read-only (error)
  ((property
    :reader property
    :initarg :property))
  (:report (lambda (c stream)
             (format stream "Property ~s is read only." (property c)))))

(define-condition unknown-key (error)
  ((instance-key
    :reader unknown-instance-key
    :initform nil
    :initarg :instance-key)
   (store
    :reader store
    :initform nil
    :initarg :store))
  (:report (lambda (c stream)
             (format stream "Instance key ~A declared unknown by ~A"
                     (unknown-instance-key c) (store c)))))

(define-condition ec-rollback-error (error)
  ((original
    :initform nil
    :initarg :original
    :reader original-error))
  (:report (lambda (c stream)
             (format stream "Error running rollback hook: ~A" (original-error c)))))
