(in-package :odcl)

(defregression (:filesystem 1)
    "creating and checking values"
  (let ((path (temp-file))
        (name 'test)
        (data '((1 . "Contumely")
                (2 . (:assert :retract :dessert))
                (3 . (5.6767 '|sumptious dinner|)))))
    (let ((fsdb (make-fsdb name path)))
      (unwind-protect
           (progn
             (dolist (datum data)
               (destructuring-bind (oid . expr)
                   datum
                 (fsdb-add fsdb oid expr)))
             (cmsg "Get 1: ~s" (fsdb-get fsdb 1))
             (cmsg "Get 2: ~s" (fsdb-get fsdb 2))
             (cmsg "Get 3: ~s" (fsdb-get fsdb 3))
             (cmsg "All contents: ~s" (list-expressions fsdb))
             (unless (= 3 (length (list-expressions fsdb)))
               (error "list-expressions failed")))
        (destroy-fsdb fsdb)))))

(defvar *ep-test-data*
  '(("foo" "bar" "foo/bar")
    ("foo/" "bar" "foo/bar")
    ("foo" "/bar" "foo/bar")
    ("" "tmp" "/tmp")))

(defregression (:filesystem 2)
    "extend path"
  (dolist (test *ep-test-data*)
    (destructuring-bind (x y z)
        test
      (unless (string= z (extend-path x y))
        (error "~s and ~s should produce ~s not ~s"
               x y z (extend-path x y))))))

(defregression (:filesystem 3.1)
    "filesystem transactions"
  (let ((path (temp-file))
        (name 'test)
        (data '((1 . "Contumely")
                (2 . (:assert :retract :dessert))
                (3 . (5.6767 '|sumptious dinner|)))))
    (let ((fsdb (make-fsdb name path)))
      (unwind-protect
           (progn
             (dolist (datum data)
               (destructuring-bind (oid . expr)
                   datum
                 (fsdb-add fsdb oid expr)))
             (cmsg "Get 1: ~s" (fsdb-get fsdb 1))
             (cmsg "Get 2: ~s" (fsdb-get fsdb 2))
             (cmsg "Get 3: ~s" (fsdb-get fsdb 3))
             
             (cmsg "All contents: ~s" (list-expressions fsdb))
             (unless (= 3 (length (list-expressions fsdb)))
               (error "list-expressions failed"))
             (unless (= 3 (length (list-expressions fsdb)))
               (error "list-expressions failed")))
        (unless (= 3 (length (list-expressions fsdb)))
          (error "list-expressions failed"))
        (destroy-fsdb fsdb)))))

(defregression (:filesystem 3.2)
    "filesystem transactions: abort/rollback"
  (let ((path (temp-file))
        (name 'test)
        (data '((1 . "Contumely")
                (2 . (:assert :retract :dessert))
                (3 . (5.6767 '|sumptious dinner|)))))
    (let ((fsdb (make-fsdb name path)))
      (unwind-protect
           (progn
             (dolist (datum data)
               (destructuring-bind (oid . expr)
                   datum
                 (fsdb-add fsdb oid expr)))
             (cmsg "Get 1: ~s" (fsdb-get fsdb 1))
             (cmsg "Get 2: ~s" (fsdb-get fsdb 2))
             (cmsg "Get 3: ~s" (fsdb-get fsdb 3))
             
             (cmsg "All contents: ~s" (list-expressions fsdb))
             (unless (= 3 (length (list-expressions fsdb)))
               (error "list-expressions failed")))
        (destroy-fsdb fsdb)))))

(defregression (:filesystem 3.3)
    "filesystem transactions: abort/rollback from adding new object"
  (let ((path (temp-file))
        (name 'test)
        (data '((1 . "Contumely")
                (2 . (:assert :retract :dessert))
                (3 . (5.6767 '|sumptious dinner|)))))
    (let ((fsdb (make-fsdb name path)))
      (unwind-protect
           (progn
             (dolist (datum data)
               (destructuring-bind (oid . expr)
                   datum
                 (fsdb-add fsdb oid expr)))
             (cmsg "Get 1: ~s" (fsdb-get fsdb 1))
             (cmsg "Get 2: ~s" (fsdb-get fsdb 2))
             (cmsg "Get 3: ~s" (fsdb-get fsdb 3))
             (cmsg "All contents: ~s" (list-expressions fsdb))
             (unless (= 3 (length (list-expressions fsdb)))
               (error "list-expressions failed")))
        (unless (= 3 (length (list-expressions fsdb)))
          (error "list-expressions failed")))

      ;; now try adding and let's rollback too
      (unwind-protect
           (progn
             (fsdb-add fsdb 4 (list "foo"))
             (cmsg "All contents: ~s" (list-expressions fsdb))
             (unless (= 4 (length (list-expressions fsdb)))
               (error "list-expressions failed")))
        (destroy-fsdb fsdb)))))

(defregression (:filesystem 3.4)
    "filesystem transactions: abort/rollback from deleting record"
  (let ((path (temp-file))
        (name 'test)
        (data '((1 . "Contumely")
                (2 . (:assert :retract :dessert))
                (3 . (5.6767 '|sumptious dinner|)))))
    (let ((fsdb (make-fsdb name path)))
      (unwind-protect
           (progn
             (dolist (datum data)
               (destructuring-bind (oid . expr)
                   datum
                 (fsdb-add fsdb oid expr)))
             (cmsg "Get 1: ~s" (fsdb-get fsdb 1))
             (cmsg "Get 2: ~s" (fsdb-get fsdb 2))
             (cmsg "Get 3: ~s" (fsdb-get fsdb 3))
             
             (cmsg "All contents: ~s" (list-expressions fsdb))
             (unless (= 3 (length (list-expressions fsdb)))
               (error "list-expressions failed 1")))
        (unless (= 3 (length (list-expressions fsdb)))
          (error "list-expressions failed 2"))))))

(defregression (:filesystem 4)
    "ensure-directory :if-exists"
  (let ((dir1     "/tmp/test.fs.4")
        (fallthru nil))
    (ensure-directory dir1 :if-exists :ignore)
    (handler-case
        (progn
          (ensure-directory dir1 :if-exists :error)
          (setf fallthru t))
      (error ()
        (cmsg "no worries")))
    (destroy-directory dir1)
    (if fallthru
        (error "ensure-directory :if-exists :error should fail"))
    nil))

(defregression (:filesystem 4.1)
    "ensure-directory :if-does-not-exist"
  (let ((dir1     "/tmp/test.fs.4")
        (fallthru nil))
    (ignore-errors (destroy-directory dir1))
    (handler-case
        (progn
          (ensure-directory dir1 :if-does-not-exist :error)
          (setf fallthru t))
      (error ()
        (cmsg "no worries")))
    (destroy-directory dir1)
    (if fallthru
        (error "ensure-directory :if-does-not-exist :error should fail"))
    nil))

(defregression (:filesystem 5.1)
    "destroy-directory"
  (let ((dir "/tmp/test.fs.5.1"))
    (ensure-directory dir)
    (destroy-directory dir)
    (expect-error error 
                  (ensure-directory dir :if-does-not-exist :error))))

(defregression (:filesystem 5.2)
    "destroying a directory we shouldn't"
  #+(or cmu sbcl)
  (if (eq (unix::unix-getuid) 0)
      (error "please don't run this as root"))
  (expect-error error 
                (destroy-directory "/tmp")))

(defregression (:filesystem 5.3)
    "destroy a directory which isn't there"
  (let ((dir "/tmp/test.fs.5.1"))
    (destroy-directory dir)
    (if (destroy-directory dir)
        (error "should return null"))))
