#!/usr/bin/perl -w
#
# extractPlist.pl
#
# Copyright (C) 2002, 2003 Wolfgang Sourdeau
#
# Author: Wolfgang Sourdeau <wolfgang@contre.com>
#
# This file is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# This file is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; see the file COPYING.  If not, write to
# the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.
#
# Note: this perl script is intended to extract meta-infos from the
#       MacOSX pbproj project files.
#
# usage: extracPlist.pl <project>.pbproj/project.pbxproj Info.plist

use strict;

use vars qw($tag_begin $tag_end);

my $project_file = $ARGV[0];
my $plist_file = $ARGV[1];

die "File undefined.\n" unless (defined $project_file
				&& defined $plist_file);

my $plist = '';

my $storing = 0;

$tag_begin = 'productSettingsXML';
$tag_end = '\";';

open PFile, $project_file
  or die "Could not open $project_file";

sub extract_begin ($) {
  my $line = shift;

  my $new_line = $line;
  $new_line =~ s/^\s*($tag_begin)\ =\ "//;

  return $new_line;
}

sub extract_end ($) {
  my $line = shift;

  my $new_line = $line;
  $new_line =~ s/$tag_end,*//;

  return $new_line;
}

while (<PFile>) {
  my $line = $_;

  chomp $line;

  if ($storing)
    {
      if ($line =~ m/$tag_end/) {
	$plist .= extract_end ($line);
	last;
      } else {
	$plist .= $line."\n";
      }
    } else {
      if ($line =~ m/($tag_begin)\ =\ "/) {
	$plist .= extract_begin ($line);
	$storing = 1;
      }
    }
}

open PLFile, '>'.$plist_file;
print PLFile $plist;
close PLFile;
