/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMAxisTraverser;
import org.apache.xpath.XPathContext;
import org.apache.xpath.axes.LocPathIterator;
import org.apache.xpath.axes.PredicatedNodeTest;
import org.apache.xpath.axes.WalkingIterator;
import org.apache.xpath.compiler.Compiler;

public class AxesWalker
extends PredicatedNodeTest
implements Cloneable {
    private DTM m_dtm;
    transient int m_root = -1;
    private transient int m_currentNode = -1;
    transient boolean m_isFresh;
    protected AxesWalker m_nextWalker;
    AxesWalker m_prevWalker;
    protected int m_axis = -1;
    protected DTMAxisTraverser m_traverser;

    public AxesWalker(LocPathIterator locPathIterator, int n) {
        super(locPathIterator);
        this.m_axis = n;
    }

    public Object clone() throws CloneNotSupportedException {
        AxesWalker axesWalker = (AxesWalker)super.clone();
        return axesWalker;
    }

    AxesWalker cloneDeep(WalkingIterator walkingIterator, Vector vector) throws CloneNotSupportedException {
        AxesWalker axesWalker = AxesWalker.findClone(this, vector);
        if (axesWalker != null) {
            return axesWalker;
        }
        axesWalker = (AxesWalker)this.clone();
        axesWalker.setLocPathIterator(walkingIterator);
        if (vector != null) {
            vector.addElement(this);
            vector.addElement(axesWalker);
        }
        if (this.wi().m_lastUsedWalker == this) {
            walkingIterator.m_lastUsedWalker = axesWalker;
        }
        if (this.m_nextWalker != null) {
            axesWalker.m_nextWalker = this.m_nextWalker.cloneDeep(walkingIterator, vector);
        }
        if (vector != null) {
            if (this.m_prevWalker != null) {
                axesWalker.m_prevWalker = this.m_prevWalker.cloneDeep(walkingIterator, vector);
            }
        } else if (this.m_nextWalker != null) {
            axesWalker.m_nextWalker.m_prevWalker = axesWalker;
        }
        return axesWalker;
    }

    static AxesWalker findClone(AxesWalker axesWalker, Vector vector) {
        if (vector != null) {
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                if (axesWalker == vector.elementAt(n2)) {
                    return (AxesWalker)vector.elementAt(n2 + 1);
                }
                n2 += 2;
            }
        }
        return null;
    }

    public int getAxis() {
        return this.m_axis;
    }

    public final int getCurrentNode() {
        return this.m_currentNode;
    }

    public DTM getDTM(int n) {
        return this.wi().getXPathContext().getDTM(n);
    }

    public int getLastPos(XPathContext xPathContext) {
        AxesWalker axesWalker;
        int n = this.getProximityPosition();
        try {
            axesWalker = (AxesWalker)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return -1;
        }
        axesWalker.setPredicateCount(axesWalker.getPredicateCount() - 1);
        axesWalker.setNextWalker(null);
        axesWalker.setPrevWalker(null);
        WalkingIterator walkingIterator = this.wi();
        AxesWalker axesWalker2 = walkingIterator.getLastUsedWalker();
        try {
            int n2;
            walkingIterator.setLastUsedWalker(axesWalker);
            while ((n2 = axesWalker.nextNode()) != -1) {
                ++n;
            }
        }
        finally {
            Object var7_7 = null;
            walkingIterator.setLastUsedWalker(axesWalker2);
        }
        return n;
    }

    protected int getNextNode() {
        if (this.m_foundLast) {
            return -1;
        }
        if (this.m_isFresh) {
            this.m_currentNode = this.m_traverser.first(this.m_root);
            this.m_isFresh = false;
        } else if (this.m_currentNode != -1) {
            this.m_currentNode = this.m_traverser.next(this.m_root, this.m_currentNode);
        }
        if (this.m_currentNode == -1) {
            this.m_foundLast = true;
        }
        return this.m_currentNode;
    }

    public AxesWalker getNextWalker() {
        return this.m_nextWalker;
    }

    public AxesWalker getPrevWalker() {
        return this.m_prevWalker;
    }

    public int getRoot() {
        return this.m_root;
    }

    public void init(Compiler compiler, int n, int n2) throws TransformerException {
        this.initPredicateInfo(compiler, n);
    }

    public boolean isDocOrdered() {
        return true;
    }

    public int nextNode() {
        int n = -1;
        AxesWalker axesWalker = this.wi().getLastUsedWalker();
        while (axesWalker != null) {
            n = axesWalker.getNextNode();
            if (n == -1) {
                axesWalker = axesWalker.m_prevWalker;
                continue;
            }
            if (axesWalker.acceptNode(n) != 1) continue;
            if (axesWalker.m_nextWalker == null) {
                this.wi().setLastUsedWalker(axesWalker);
                break;
            }
            AxesWalker axesWalker2 = axesWalker;
            axesWalker = axesWalker.m_nextWalker;
            axesWalker.setRoot(n);
            axesWalker.m_prevWalker = axesWalker2;
        }
        return n;
    }

    private int returnNextNode(int n) {
        return n;
    }

    public void setDefaultDTM(DTM dTM) {
        this.m_dtm = dTM;
    }

    public void setNextWalker(AxesWalker axesWalker) {
        this.m_nextWalker = axesWalker;
    }

    public void setPrevWalker(AxesWalker axesWalker) {
        this.m_prevWalker = axesWalker;
    }

    public void setRoot(int n) {
        this.m_dtm = this.wi().getXPathContext().getDTM(n);
        this.m_traverser = this.m_dtm.getAxisTraverser(this.m_axis);
        this.m_isFresh = true;
        this.m_foundLast = false;
        this.m_root = n;
        this.m_currentNode = n;
        if (n == -1) {
            throw new RuntimeException("\n !!!! Error! Setting the root of a walker to null!!!");
        }
        this.resetProximityPositions();
    }

    public final WalkingIterator wi() {
        return (WalkingIterator)this.m_lpi;
    }
}

