/******************************************************************************
Implementazione degli array dinamici
Giussani Cristian
Funzioni esportate dal modulo:
int Init_DArray ( struct MY_ARRAY *array, unsigned int size, unsigned int dim_init, unsigned int increment )
int Insert_DArray ( struct MY_ARRAY *array, char *element )
char *Alloc_DArray ( struct MY_ARRAY *array )
char *Pop_DArray ( struct MY_ARRAY *array )
int Set_DArray ( struct MY_ARRAY *array, char *element, int index )
int Get_DArray ( struct MY_ARRAY *array, char *element, int index )
int Delete_DArray ( struct MY_ARRAY *array )
void Purge_Array ( struct MY_ARRAY *array )
******************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <my_array.h>
#include <define.h>

int 
Init_DArray (struct MY_ARRAY *array, unsigned int size, unsigned int dim_init, unsigned int increment)
{
  if (increment == 0)
    increment = 16;

  if (dim_init == 0)
    dim_init = 16;

  array->elements = 0;
  array->max_elements = dim_init;
  array->size = size;
  array->increment = increment;

  if ((array->dati = malloc (size * dim_init)) == NULL)
    {
      array->max_elements = 0;
      return (ERR);
    }

  return (OK);
}

int 
Insert_DArray (struct MY_ARRAY *array, char *element)
{
  auto char *buffer;

  if (array->elements == array->max_elements)
    {
      /* --------------------------------- Aggiunge celle all'array */
      if ((buffer = Alloc_DArray (array)) == NULL)
	return (ERR);
    }
  else
    {
      /* ------------------------------------ Nell'array c'e' posto */
      buffer = array->dati + (array->elements * array->size);
      array->elements++;
    }

  memcpy (buffer, element, (size_t) array->size);
  return (OK);
}

char *
Alloc_DArray (struct MY_ARRAY *array)
{
  if (array->elements == array->max_elements)
    {
      char *buffer;

      if ((buffer = malloc ((array->max_elements + array->increment) * array->size)) == NULL)
	{
	  return (NULL);
	}
      memcpy (buffer, array->dati, (array->elements * array->size));
      free (array->dati);
      array->dati = buffer;
      array->max_elements += array->increment;
    }

  return (array->dati + (array->elements++ * array->size));
}

char *
Pop_DArray (struct MY_ARRAY *array)
{
  if (array->elements > 0)
    {
      return (array->dati + (--array->elements * array->size));
    }

  return (NULL);
}

int 
Set_DArray (struct MY_ARRAY *array, char *element, int index)
{
  if (index >= array->elements)
    {
      if (index >= array->max_elements)
	{
	  unsigned int size;
	  char *buffer;

	  size = (index + array->increment) / array->increment;
	  size *= array->increment;
	  if ((buffer = malloc (size * array->size)) == NULL)
	    {
	      return (ERR);
	    }
	  memcpy (buffer, array->dati, array->elements * array->size);
	  free (array->dati);
	  array->dati = buffer;
	  array->max_elements = size;
	}

      memset (array->dati + (array->elements * array->size), 0, (index - array->elements) * array->size);
      array->elements = index + 1;
    }

  memcpy (array->dati + (index * array->size), element, (size_t) array->size);

  return (OK);
}

int 
Get_DArray (struct MY_ARRAY *array, char *element, int index)
{
  if (index >= array->elements)
    {
      memset (element, 0, array->size);
      return (ERR);
    }

  memcpy (element, array->dati + (index * array->size), (size_t) array->size);
  return (OK);
}

int 
Delete_DArray (struct MY_ARRAY *array)
{
  if (array->dati)
    {
      free (array->dati);
      array->dati = NULL;
      array->max_elements = 0;
      array->elements = 0;
    }

  return (OK);
}

void 
Purge_Array (struct MY_ARRAY *array)
{
  unsigned int elements;

  if (array->elements == 0)
    elements = 1;
  else
    elements = array->elements;

  if ((array->dati != NULL) && (elements != array->max_elements))
    {
      char *buffer;
      if ((buffer = malloc (elements * array->size)) == NULL)
	return;
      memcpy (buffer, array->dati, elements * array->size);
      free (array->dati);
      array->dati = buffer;
      array->max_elements = elements;
    }

  return;
}

int 
debug_array (struct MY_ARRAY *array)
{
  printf ("Elementi %d\nMassimo %d\nIncremento %d\n", array->elements, array->max_elements, array->increment);
  return (0);
}

#ifdef TEST
int 
main (int argc, char *argv[])
{
  struct MY_ARRAY array;
  char buffer[80];
  char buffer2[80];
  char *cptrdmy;

  Init_DArray (&array, sizeof (buffer), 1, 1);
  debug_array (&array);

  sprintf (buffer, "Primo");
  Insert_DArray (&array, buffer);
  debug_array (&array);

  sprintf (buffer, "Secondo");
  Insert_DArray (&array, buffer);
  debug_array (&array);

  sprintf (buffer, "Terzo");
  Insert_DArray (&array, buffer);
  debug_array (&array);

  sprintf (buffer, "Quinto");
  Set_DArray (&array, buffer, 4);
  debug_array (&array);

  Get_DArray (&array, buffer2, 2);
  printf ("Stampo il 3 '%s'\n", buffer2);

  while ((cptrdmy = Pop_DArray (&array)) != NULL)
    printf ("Prelevato '%s'\n", cptrdmy);

  Delete_DArray (&array);

  return (0);
}
#endif
