<?php
/*
 * $Id: class.dbFaq.inc.php,v 1.2.4.1 2003/05/30 03:56:39 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('db');
class dbFaq extends dclDB
{
	var $faqid;
	var $name;
	var $description;
	var $createby;
	var $createdate;
	var $modifyby;
	var $modifydate;
	var $active;

	function dbFaq()
	{
           // Table Fields
		$this->fieldArray = array(
				'faqid', 
				'name', 
				'description', 
				'createby', 
				'createon', 
				'modifyby', 
				'modifyon', 
				'active');

           // Foreign keys
		$this->foreignKeys = array('faqtopics' => 'faqid');

		$this->cache = array();
		$this->cacheEnabled = false;

		$this->dclDB();
	}

	function Add()
	{
		$idSQL = $this->GetNewIDSQLForTable('faq');
		$query = 'INSERT INTO faq (';
		if ($idSQL != '')
			$query .= 'faqid,';
		$query .= 'name,description,createby,createon,active)';
		$query .= ' VALUES (';
		if ($idSQL != '')
			$query .= $idSQL . ',';
		$query .= '\'' . $this->DBAddSlashes($this->name) . '\',';
		$query .= '\'' . $this->DBAddSlashes($this->description) . '\',';
		$query .= $this->DBAddSlashes($this->createby) . ',';
		$query .= $this->GetDateSQL() . ',';
		$query .= '\'Y\')';

		if ($this->Insert($query) == -1)
		{
			echo '<BR>' . sprintf(STR_DB_FAQINSERTERR, $query) . '<BR>';
		}
	}

	function Edit()
	{
		$query = 'UPDATE faq SET ';
		$query .= 'name=\'' . $this->DBAddSlashes($this->name) . '\',';
		$query .= 'description=\'' . $this->DBAddSlashes($this->description) . '\',';
		$query .= 'modifyby=' . $GLOBALS['DCLID'] . ',';
		$query .= 'modifyon=' . $this->GetDateSQL() . ',';
		$query .= 'active=\'' . $this->active . '\'';
		$query .= ' WHERE faqid=' . $this->faqid;

		$this->Execute($query);
	}

	function Delete()
	{
		$query = 'DELETE FROM faq WHERE id=' . $this->faqid;
		return $this->Execute($query);
	}

	function SetActive($active)
	{
		$isActive = 'N';
		if ($active)
			$isActive = 'Y';

		$query = 'UPDATE faq SET ';
		$query .= "active='$isActive'";
		$query .= ' WHERE faqid=' . $this->faqid;

		return $this->Execute($query);
	}

	function GetRow()
	{
		if (!$this->res)
			return -1;

		if (count($this->Record) > 0)
		{
			$this->faqid = $this->f('faqid');
			$this->name = trim($this->f('name'));
			$this->description = trim($this->f('description'));
			$this->createby = $this->f('createby');
			$this->createdate = $this->FormatTimestampForDisplay($this->f('createon'));
			$this->modifyby = $this->f('modifyby');
			$this->modifydate = $this->FormatTimestampForDisplay($this->f('modifyon'));
			$this->active = $this->f('active');

			if ($this->cacheEnabled)
				$this->CacheRow($this->faqid);
		}
		else
			$this->Clear();
	}

	function Load($id)
	{
		$this->Clear();

		if ($this->cacheEnabled && $this->LoadCache($id) != -1)
			return 0;

		if ($this->conn == 0)
		{
			if (!$this->Connect())
				return -1;
		}

		$sql = 'SELECT faqid, name, description, createby, ';
		$sql .= $this->ConvertTimestamp('createon', 'createon');
		$sql .= ', modifyby, ';
		$sql .= $this->ConvertTimestamp('modifyon', 'modifyon');
		$sql .= ", active FROM faq WHERE faqid=$id";
		if (!$this->Query($sql))
			return -1;

		$this->next_record();
		return $this->GetRow();
	}

	function Clear()
	{
		$this->faqid = 0;
		$this->name = '';
		$this->description = '';
		$this->createby = 0;
		$this->createon = '';
		$this->modifyby = 0;
		$this->modifyon = '';
		$this->active = '';
	}
}
?>
