<?php
/*
 * $Id: class.dbLookup.inc.php,v 1.2 2001/09/23 21:33:38 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('db');
class dbLookup extends dclDB
{
	var $dcl_lookup_id;
	var $dcl_lookup_name;
	var $dcl_lookup_active;

	function dbLookup()
	{
           // Table Fields
		$this->fieldArray = array('dcl_lookup_id', 'dcl_lookup_name', 'dcl_lookup_active');

           // Foreign keys
		$this->foreignKeys = array('dcl_lookup_item' => 'dcl_lookup_id');

		$this->cache = array();
		$this->cacheEnabled = true;

		$this->dclDB();
	}

	function Add()
	{
		$idSQL = $this->GetNewIDSQLForTable('dcl_lookup');
		$query = 'INSERT INTO dcl_lookup (';
		if ($idSQL != '')
			$query .= 'dcl_lookup_id, ';
		$query .= 'dcl_lookup_name, dcl_lookup_active)';
		$query .= ' VALUES (';
		if ($idSQL != '')
			$query .= $idSQL . ',';
		$query .= '\'' . $this->DBAddSlashes($this->dcl_lookup_name) . '\',\'Y\')';

		if ($this->Insert($query) == -1)
		{
			echo '<BR>' . sprintf(STR_DB_INSERTERR, $query) . '<BR>';
		}
	}

	function Edit()
	{
		$query = 'UPDATE dcl_lookup SET ';
		$query .= 'dcl_lookup_name=\'' . $this->DBAddSlashes($this->dcl_lookup_name) . '\',';
		$query .= 'dcl_lookup_active=\'' . $this->dcl_lookup_active . '\'';
		$query .= ' WHERE dcl_lookup_id=' . $this->dcl_lookup_id;

		$this->Execute($query);
	}

	function Delete()
	{
		$query = 'DELETE FROM dcl_lookup WHERE dcl_lookup_id=' . $this->dcl_lookup_id;
		return $this->Execute($query);
	}

	function SetActive($active)
	{
		$isActive = 'N';
		if ($active)
			$isActive = 'Y';

		$query = 'UPDATE dcl_lookup SET ';
		$query .= "dcl_lookup_active='$isActive'";
		$query .= ' WHERE dcl_lookup_id=' . $this->dcl_lookup_id;

		return $this->Execute($query);
	}

	function GetRow()
	{
		if (!$this->res)
			return -1;

		if (count($this->Record) > 0)
		{
			$this->dcl_lookup_id = $this->f('dcl_lookup_id');
			$this->dcl_lookup_name = trim($this->f('dcl_lookup_name'));
			$this->dcl_lookup_active = $this->f('dcl_lookup_active');

			if ($this->cacheEnabled)
				$this->CacheRow($this->dcl_lookup_id);
		}
		else
			$this->Clear();
	}

	function Load($id)
	{
		$this->Clear();

		if ($this->cacheEnabled && $this->LoadCache($id) != -1)
			return 0;

		if ($this->conn == 0)
		{
			if (!$this->Connect())
				return -1;
		}

		$sql = "SELECT dcl_lookup_id, dcl_lookup_name, dcl_lookup_active FROM dcl_lookup WHERE dcl_lookup_id=$id";
		if (!$this->Query($sql))
			return -1;

		$this->next_record();
		return $this->GetRow();
	}

	function Clear()
	{
		$this->dcl_lookup_id = 0;
		$this->dcl_lookup_name = '';
		$this->dcl_lookup_active = '';
	}
}
?>
