<?php
/*
 * $Id: class.dbProducts.inc.php,v 1.2.4.1 2002/10/22 00:32:08 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('db');

class dbProducts extends dclDB
{
	var $id;
	var $short;
	var $name;
	var $reportto;
	var $active;
	var $ticketsto;
	var $wosetid;
	var $tcksetid;

	function dbProducts()
	{
           // Table Fields
		$this->fieldArray = array('id', 'short', 'name', 'reportto', 'active', 'ticketsto', 'wosetid', 'tcksetid');

           // Foriegn keys
		$this->foreignKeys = array(
				'workorders' => 'product',
				'tickets' => 'product',
				'dcl_product_module' => 'product_id');

		$this->cache = array();
		$this->cacheEnabled = true;

		$this->dclDB();
	}

	function Add()
	{
		$idSQL = $this->GetNewIDSQLForTable('products');
		$query = 'INSERT INTO products (';
		if ($idSQL != '')
			$query .= 'id,';
		$query .= 'short,name,reportto,active,ticketsto,wosetid,tcksetid)';
		$query .= ' VALUES (';
		if ($idSQL != '')
			$query .= $idSQL . ',';
		$query .= '\'' . $this->DBAddSlashes($this->short) . '\',';
		$query .= '\'' . $this->DBAddSlashes($this->name) . '\',';
		$query .= $this->reportto . ',\'Y\',';
		$query .= $this->ticketsto . ',';
		$query .= $this->wosetid . ',';
		$query .= $this->tcksetid . ')';

		if ($this->Insert($query) == -1)
		{
			echo '<BR>' . sprintf(STR_DB_PRODUCTINSERTERR, $query) . '<BR>';
		}
	}

	function Edit()
	{
		$query = 'UPDATE products SET ';
		$query .= 'short=\'' . $this->DBAddSlashes($this->short) . '\',';
		$query .= 'name=\'' . $this->DBAddSlashes($this->name) . '\',';
		$query .= 'reportto=' . $this->reportto;
		$query .= ',active=\'' . $this->active . '\'';
		$query .= ',ticketsto=' . $this->ticketsto;
		$query .= ',wosetid=' . $this->wosetid;
		$query .= ',tcksetid=' . $this->tcksetid;
		$query .= ' WHERE id=' . $this->id;

		$this->Execute($query);
	}

	function Delete()
	{
		$query = 'DELETE FROM products WHERE id=' . $this->id;
		return $this->Execute($query);
	}

	function SetActive($active)
	{
		$isActive = 'N';
		if ($active)
			$isActive = 'Y';

		$query = 'UPDATE products SET ';
		$query .= "active='$isActive'";
		$query .= ' WHERE id=' . $this->id;

		return $this->Execute($query);
	}

	function GetRow()
	{
		if (!$this->res)
			return -1;

		if (count($this->Record) > 0)
		{
			$this->id = $this->f('id');
			$this->short = trim($this->f('short'));
			$this->name = trim($this->f('name'));
			$this->reportto = $this->f('reportto');
			$this->active = $this->f('active');
			$this->ticketsto = $this->f('ticketsto');
			$this->wosetid = $this->f('wosetid');
			$this->tcksetid = $this->f('tcksetid');

			if ($this->cacheEnabled)
				$this->CacheRow($this->id);
		}
		else
			$this->Clear();
	}

	function Load($id)
	{
		$this->Clear();

		if ($this->cacheEnabled && $this->LoadCache($id) != -1)
			return 0;

		if ($this->conn == 0)
		{
			if (!$this->Connect())
				return -1;
		}

		$sql = "SELECT * FROM products WHERE id=$id";
		if (!$this->Query($sql))
			return -1;

		$this->next_record();
		return $this->GetRow();
	}

	function Clear()
	{
		$this->id = 0;
		$this->short = '';
		$this->name = '';
		$this->reportto = 0;
		$this->active = '';
		$this->ticketsto = 0;
		$this->wosetid = 0;
		$this->tcksetid = 0;
	}
}
?>
