<?php
/*
 * $Id: class.dbWatches.inc.php,v 1.2.2.1 2002/01/20 19:19:36 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('db');
LoadStringResource('wtch');

class dbWatches extends dclDB
{
	var $watchid;
	var $typeid;
	var $whatid1;
	var $whatid2;
	var $whoid;
	var $actions;

	var $arrTypeid;
	var $arrActions;

	function dbWatches()
	{
           //Table Fields
		$this->fieldArray = array('watchid', 'typeid', 'whatid1', 'whatid2', 'whoid', 'actions');

           // Foreign keys
		$this->foreignKeys = array();

		$this->cache = array();
		$this->cacheEnabled = true;

		$this->arrTypeid = array(
				1 => STR_WTCH_PRODUCTWO, 
				2 => STR_WTCH_PROJECT, 
				3 => STR_WTCH_WORKORDER, 
				4 => STR_WTCH_PRODUCTTICKET, 
				5 => STR_WTCH_TICKET,
				6 => STR_WTCH_ACCTWO,
				7 => STR_WTCH_ACCTTCK
			);

		$this->arrActions = array(
				1 => STR_WTCH_OPEN, 
				2 => STR_WTCH_CLOSED, 
				3 => STR_WTCH_STATUS, 
				4 => STR_WTCH_ANYTHING
			);

		$this->dclDB();
	}

	function Add()
	{
		$idSQL = $this->GetNewIDSQLForTable('watches');
		$query = 'INSERT INTO watches (';
		if ($idSQL != '')
			$query .= 'watchid,';
		$query .= 'typeid,whatid1,whatid2,whoid,actions)';
		$query .= ' VALUES (';
		if ($idSQL != '')
			$query .= $idSQL . ',';
		$query .= sprintf('%d,%d,%d,%d,%d)', 
				$this->typeid, $this->whatid1, $this->whatid2, $this->whoid, $this->actions);

		if ($this->Insert($query) == -1)
		{
			echo '<BR>' . sprintf(STR_DB_WATCHINSERTERR, $query) . '<BR>';
		}
	}

	function Edit()
	{
		$query = 'UPDATE watches SET ';
		$query .= sprintf('typeid=%d,whatid1=%d,whatid2=%d,whoid=%d,actions=%d', 
				$this->typeid, $this->whatid1, $this->whatid2, $this->whoid, $this->actions);
		$query .= ' WHERE watchid=' . $this->watchid;

		$this->Execute($query);
	}

	function Delete()
	{
		$query = 'DELETE FROM watches WHERE watchid=' . $this->watchid;
		return $this->Execute($query);
	}

	function DeleteByObjectID($type, $key1, $key2 = 0)
	{
		$query = "DELETE FROM watches WHERE type=$type AND whatid1=$key1 AND whatid2=$key2";
		return $this->Execute($query);
	}

	function SetActive($active)
	{
		return 0;
	}

	function GetRow()
	{
		if (!$this->res)
			return -1;

		if (count($this->Record) > 0)
		{
			$this->watchid = $this->f('watchid');
			$this->typeid = $this->f('typeid');
			$this->whatid1 = $this->f('whatid1');
			$this->whatid2 = $this->f('whatid2');
			$this->whoid = $this->f('whoid');
			$this->actions = $this->f('actions');

			if ($this->cacheEnabled)
				$this->CacheRow($this->watchid);
		}
		else
			$this->Clear();
	}

	function Load($id)
	{
		$this->Clear();

		if ($this->cacheEnabled && $this->LoadCache($id) != -1)
			return 0;

		if (!$this->conn)
		{
			if (!$this->Connect())
				return -1;
		}

		$sql = "SELECT * FROM watches WHERE watchid=$id";
		if (!$this->Query($sql))
			return -1;

		$this->next_record();
		return $this->GetRow();
	}

	function Clear()
	{
		$this->watchid = 0;
		$this->typeid = 0;
		$this->whatid1 = 0;
		$this->whatid2 = 0;
		$this->whoid = 0;
		$this->actions = 0;
	}
}
?>
