<?php
/*
 * $Id: class.dbWorkOrderAccount.inc.php,v 1.1.2.1 2003/04/19 23:44:15 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('db');
class dbWorkOrderAccount extends dclDB
{
	var $wo_id;
	var $seq;
	var $account_id;
	var $account_name; // not part of table, but useful for Load

	function dbProjectmap()
	{
		// Table Fields
		$this->fieldArray = array('wo_id', 'seq', 'account_id');

		// Foreign Keys
		$this->foreignKeys = array();

		$this->cacheEnabled = false;
		$this->dclDB();
	}

	function Add()
	{
		if ($this->conn == 0)
		{
			if(!$this->Connect())
				return -1;
		}

		$query  = 'INSERT INTO dcl_wo_account (wo_id, seq, account_id) Values (';
		$query .= $this->wo_id . ', ';
		$query .= $this->seq . ', ';
		$query .= $this->account_id;
		$query .= ')';

		if ($this->Insert($query) == -1)
		{
			print(sprintf(STR_DB_PROJECTMAPINSERTERR, $query));
		}
	}

	function Edit()
	{
	}

	function Delete($wo_id, $seq, $account_id)
	{
		if ($this->conn == 0)
		{
			if (!$this->Connect())
				return -1;
		}

		$query = sprintf('Delete From dcl_wo_account Where wo_id = %d And seq = %d And account_id = %d', $wo_id, $seq, $account_id);

		return $this->Execute($query);
	}

	function DeleteByWorkOrder($wo_id, $seq)
	{
		if ($this->conn == 0)
		{
			if (!$this->Connect())
				return -1;
		}

		$query = sprintf('Delete From dcl_wo_account Where wo_id = %d And seq = %d', $wo_id, $seq);

		return $this->Execute($query);
	}

	function GetRow()
	{
		if (!$this->res || count($this->Record) < 1)
			return -1;

		$this->wo_id = $this->f('wo_id');
		$this->seq = $this->f('seq');
		$this->account_id = $this->f('account_id');
		$this->account_name = $this->f('name');
	}

	function Load($wo_id, $seq)
	{
		$this->Clear();

		if ($this->conn == 0)
		{
			if (!$this->Connect())
				return -1;
		}

		// Get all rows since we read with GetRow
		$sql = sprintf('Select wo_id, seq, account_id, name From dcl_wo_account, accounts Where account_id = id And wo_id = %d And seq = %d Order By name', $wo_id, $seq);
		if (!$this->Query($sql))
			return -1;

		if (!$this->next_record())
			return -1;

		return $this->GetRow();
	}

	function Clear()
	{
		$this->wo_id = 0;
		$this->seq = 0;
		$this->account_id = 0;
	}
}
?>
