<?php
    /*
     * $Id: logout.php,v 1.1.2.4 2003/12/14 01:09:26 mdean Exp $
     *
     * Double Choco Latte - Source Configuration Management System
     * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
     *
     * This program is free software; you can redistribute it and/or
     * modify it under the terms of the GNU General Public License
     * as published by the Free Software Foundation; either version 2
     * of the License, or (at your option) any later version.
     *
     * This program is distributed in the hope that it will be useful,
     * but WITHOUT ANY WARRANTY; without even the implied warranty of
     * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     * GNU General Public License for more details.
     *
     * You should have received a copy of the GNU General Public License
     * along with this program; if not, write to the Free Software
     * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
     *
     * Select License Info from the Help menu to view the terms and conditions of this license.
     */

if (!defined('__DCL_CONFIG_INCLUDED__'))
	include('inc/config.php');

include(DCL_ROOT . 'inc/functions.inc.php');

$g_oSession = CreateObject('dcl.dbSession');
list($dcl_session_id, $DOMAIN) = explode('/', $HTTP_COOKIE_VARS['DCLINFO']);
if (strlen($dcl_session_id) == 32)
{
	$g_oSession->Connect();
	if (!$g_oSession->conn)
		Refresh(DCL_WWW_ROOT . 'index.php?cd=3');

	if ($g_oSession->Load($dcl_session_id) == false)
		Refresh(DCL_WWW_ROOT . 'index.php?cd=2');

	if ($g_oSession->IsValidSession())
	{
		$g_oSession->Delete($g_oSession->dcl_session_id);
		$g_oSession->Clear();
	}
}

Refresh(DCL_WWW_ROOT . 'index.php?cd=4');

function Refresh($toHere = 'index.php', $session_id = '', $domain = 'default')
{
	global $DCLINFO, $DCLUI;
	if (!empty($_SERVER))
		extract($_SERVER);
	else if (!empty($HTTP_SERVER_VARS))
		extract($HTTP_SERVER_VARS);

	$bIsLogin = (substr($toHere, 0, 9) == 'index.php');

	if ($bIsLogin)
	{
		$theCookie = '';
		if (IsSet($QUERY_STRING) && $QUERY_STRING != '')
			$toHere .= sprintf('%srefer_to=%s', strpos($toHere, '?') > 0 ? '&' : '?', urlencode($QUERY_STRING));
	}
	else
		$theCookie = $session_id . '/' . $domain;

	if (DCL_COOKIE_METHOD == 'header')
	{
		$hdr = '';
		if ($GLOBALS['redirMethod'] == 'php')
			$hdr = "Location: $toHere\n";

		$hdr .= "Set-Cookie: DCLINFO=$theCookie\n";
		$hdr .= "\n";

		Header($hdr);
		if ($bIsLogin)
			exit;
	}

	if (DCL_COOKIE_METHOD == 'php')
	{
		$httpDomain = '';
		if (ereg('^[0-9]{2,3}\.[0-9]{2,3}\.[0-9]{2,3}\.[0-9]{2,3}$', $HTTP_HOST))
		{
			$httpDomain = $HTTP_HOST;
		}
		else if (ereg('.*\..*$', $HTTP_HOST))
		{
			$httpDomain = eregi_replace('^www\.', '', $HTTP_HOST);
			$httpDomain = '.' . $httpDomain;
		}

		SetCookie('DCLINFO', $theCookie, 0, '/', $httpDomain);

		if (DCL_REDIR_METHOD == 'php')
		{
			Header("Location: $toHere\n\n");
			if ($bIsLogin)
				exit;
		}
	}

	print('<html><head>');

	if (DCL_COOKIE_METHOD == 'meta')
	{
		print("<meta http-equiv=\"Set-Cookie\" content=\"DCLINFO=$theCookie\">");
	}

	print("<meta http-equiv=\"refresh\" content=\"00;URL=$toHere\">");
	print('</head>');
	if ($bIsLogin)
	{
		print('<body bgcolor="#FFFFFF"></body></html>');
		exit;
	}
}
?>
