<?xml version="1.0"?> 
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<xsl:template match="/"><sql>
		<xsl:for-each select="tables/table">
			<xsl:call-template name="doTable"/>
			<xsl:call-template name="doPrimaryKey"><xsl:with-param name="table"><xsl:value-of select="@name"/></xsl:with-param></xsl:call-template>
			<xsl:call-template name="doIndexes"><xsl:with-param name="table"><xsl:value-of select="@name"/></xsl:with-param></xsl:call-template>
			<xsl:call-template name="doConstraints"><xsl:with-param name="table"><xsl:value-of select="@name"/></xsl:with-param></xsl:call-template>
		</xsl:for-each></sql>
	</xsl:template>

	<xsl:template name="doTable"><xsl:variable name="numFields" select="count(fields/field)"/><xsl:variable name="tableName" select="@name"/>
	<command>Create Table <xsl:value-of select="$tableName"/> (<xsl:for-each select="fields/field">
			<xsl:value-of select="@name"/>
			<xsl:choose>
				<xsl:when test="@type = &quot;auto&quot;"><xsl:text> numeric(11,0) identity</xsl:text></xsl:when>
				<xsl:when test="@type = &quot;int&quot;">
					<xsl:choose>
						<xsl:when test="@size = 2"><xsl:text> smallint</xsl:text></xsl:when>
						<xsl:when test="@size = 4"><xsl:text> int</xsl:text></xsl:when>
						<xsl:when test="@size = 8"><xsl:text> int</xsl:text></xsl:when>
					</xsl:choose>
				</xsl:when>
				<xsl:when test="@type = &quot;float&quot;">
					<xsl:choose>
						<xsl:when test="@size = 4"><xsl:text> float</xsl:text></xsl:when>
						<xsl:when test="@size = 8"><xsl:text> real</xsl:text></xsl:when>
					</xsl:choose>
				</xsl:when>
				<xsl:when test="@type = &quot;decimal&quot;"><xsl:text> </xsl:text><xsl:value-of select="@type"/>(<xsl:value-of select="@precision"/>,<xsl:value-of select="@scale"/>)</xsl:when>
				<xsl:when test="@type = &quot;varchar&quot;"><xsl:text> </xsl:text><xsl:value-of select="@type"/>(<xsl:value-of select="@size"/>)</xsl:when>
				<xsl:when test="@type = &quot;char&quot;"><xsl:text> </xsl:text><xsl:value-of select="@type"/>(<xsl:value-of select="@size"/>)</xsl:when>
				<xsl:when test="@type = &quot;blob&quot;"><xsl:text> image</xsl:text></xsl:when>
				<xsl:when test="@type = &quot;date&quot;"><xsl:text> smalldatetime</xsl:text></xsl:when>
				<xsl:when test="@type = &quot;datetime&quot;"><xsl:text> datetime</xsl:text></xsl:when>
				<xsl:when test="@type = &quot;longtext&quot;"><xsl:text> text</xsl:text></xsl:when>
				<xsl:when test="@type = &quot;text&quot;"><xsl:text> </xsl:text><xsl:value-of select="@type"/></xsl:when>
				<xsl:when test="@type = &quot;timestamp&quot;"><xsl:text> timestamp</xsl:text></xsl:when>
				<xsl:otherwise><xsl:text> UNHANDLED TYPE(</xsl:text><xsl:value-of select="@type"/>)</xsl:otherwise>
			</xsl:choose>
			<xsl:choose>
				<xsl:when test="@nullable = &quot;N&quot;"><xsl:text> NOT NULL</xsl:text></xsl:when><xsl:otherwise><xsl:text> NULL</xsl:text></xsl:otherwise>
			</xsl:choose>
			<xsl:if test="@default != &quot;&quot;"><xsl:text> default </xsl:text>
				<xsl:choose>
				<xsl:when test="@default = &quot;getdate()&quot;">GetDate()</xsl:when>
				<xsl:otherwise><xsl:value-of select="@default"/></xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<xsl:if test="position() &lt; $numFields">, </xsl:if>
		</xsl:for-each>)<xsl:text>
GO
</xsl:text></command>
	</xsl:template>

	<xsl:template name="doPrimaryKey">
		<xsl:param name="table"></xsl:param>
		<xsl:if test="$table != &quot;&quot;">
			<xsl:if test="count(./primarykey/pkfield[text()]) &gt; 0">
				<command><xsl:text>Alter Table </xsl:text><xsl:value-of select="$table"/><xsl:text> Add Constraint </xsl:text>
				<xsl:value-of select="primarykey/@name"/><xsl:text> Primary Key(</xsl:text>
				<xsl:for-each select="primarykey/pkfield">
					<xsl:if test="position() &gt; 1"><xsl:text>, </xsl:text></xsl:if>
					<xsl:value-of select="."/>
				</xsl:for-each>
				<xsl:text>)
GO
</xsl:text></command>
			</xsl:if>
		</xsl:if>
	</xsl:template>

	<xsl:template name="doIndexes">
		<xsl:param name="table"></xsl:param>
		<xsl:if test="$table != &quot;&quot;">
			<xsl:for-each select="indexes/index">
				<command><xsl:text>Create </xsl:text>
				<xsl:if test="@type = &quot;unique&quot;"><xsl:text>Unique </xsl:text></xsl:if>
				<xsl:text> Index </xsl:text><xsl:value-of select="@name"/><xsl:text> On </xsl:text>
				<xsl:value-of select="$table"/>
				<xsl:text>(</xsl:text>
				<xsl:for-each select="idxfield">
					<xsl:if test="position() &gt; 1"><xsl:text>, </xsl:text></xsl:if>
					<xsl:value-of select="."/>
				</xsl:for-each>
				<xsl:text>)
GO
</xsl:text></command>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>

	<xsl:template name="doConstraints">
		<xsl:param name="table"></xsl:param>
		<xsl:if test="$table != &quot;&quot;">
			<xsl:for-each select="constraints/constraint">
				<command>
				<xsl:choose>
				<xsl:when test="@type = &quot;unique&quot;">
					<xsl:text>Alter Table </xsl:text><xsl:value-of select="$table"/><xsl:text> Add Constraint </xsl:text>
					<xsl:value-of select="@name"/><xsl:text> Unique (</xsl:text>
					<xsl:for-each select="constraintfield">
						<xsl:if test="position() &gt; 1"><xsl:text>, </xsl:text></xsl:if>
						<xsl:value-of select="."/>
					</xsl:for-each>
				</xsl:when>
				<xsl:when test="@type = &quot;foreignkey&quot;">
					<xsl:text>Alter Table </xsl:text><xsl:value-of select="$table"/><xsl:text> Add Constraint </xsl:text>
					<xsl:value-of select="@name"/><xsl:text> foreign key (</xsl:text>
					<xsl:value-of select="ref/@sourceField"/><xsl:text>) references </xsl:text>
					<xsl:value-of select="ref/@destinationTable"/><xsl:text>(</xsl:text><xsl:value-of select="ref/@destinationField"/>
				</xsl:when>
				</xsl:choose>
				<xsl:text>)
GO
</xsl:text>
				</command>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>
