## -*- perl -*-
## ----------------------------------------------------------------------
## DebianDoc_SGML/Locale/Alias.pm: locale aliases for i18n support
## ----------------------------------------------------------------------
## Copyright (C) 1998-2004 Ardo van Rangelrooij
##
## This is free software; see the GNU General Public Licence
## version 2 or later for copying conditions.  There is NO warranty.
## ----------------------------------------------------------------------

## ----------------------------------------------------------------------
## package interface definition
package DebianDoc_SGML::Locale::Alias;
use strict;
use vars qw( @ISA @EXPORT );
use Exporter;
@ISA = qw( Exporter );
@EXPORT = qw( %locale_aliases );

## ----------------------------------------------------------------------
## locale alias definitions
use vars qw( %locale_aliases );
%locale_aliases = (

		   'ca'				=> 'ca_ES.ISO8859-1',
		   'ca_ES'			=> 'ca_ES.ISO8859-1',
		   'ca_ES.ISO8859-1'		=> 'ca_ES.ISO8859-1',

		   'ca_ES@euro'			=> 'ca_ES.ISO8859-15',
		   'ca_ES.ISO8859-15'		=> 'ca_ES.ISO8859-15',
		   'ca_ES.ISO8859-15@euro'	=> 'ca_ES.ISO8859-15',

		   'cs'				=> 'cs_CZ.ISO8859-2',
		   'cs_CZ'			=> 'cs_CZ.ISO8859-2',
		   'cs_CZ.ISO8859-2'		=> 'cs_CZ.ISO8859-2',

		   'da'				=> 'da_DK.ISO8859-1',
		   'da_DK'			=> 'da_DK.ISO8859-1',
		   'da_DK.ISO8859-1'		=> 'da_DK.ISO8859-1',

		   'de'				=> 'de_DE.ISO8859-1',
		   'de_DE'			=> 'de_DE.ISO8859-1',
		   'de_DE.ISO8859-1'		=> 'de_DE.ISO8859-1',

		   'de_DE@euro'			=> 'de_DE.ISO8859-15',
		   'de_DE.ISO8859-15'		=> 'de_DE.ISO8859-15',
		   'de_DE.ISO8859-15@euro'	=> 'de_DE.ISO8859-15',

		   'en'				=> 'en_US.ISO8859-1',
		   'en_US'			=> 'en_US.ISO8859-1',
		   'en_US.ISO8859-1'		=> 'en_US.ISO8859-1',

		   'es'				=> 'es_ES.ISO8859-1',
		   'es_ES'			=> 'es_ES.ISO8859-1',
		   'es_ES.ISO8859-1'		=> 'es_ES.ISO8859-1',

		   'es_ES@euro'			=> 'es_ES.ISO8859-15',
		   'es_ES.ISO8859-15	'	=> 'es_ES.ISO8859-15',
		   'es_ES.ISO8859-15@euro'	=> 'es_ES.ISO8859-15',

		   'eu'				=> 'eu_ES.ISO8859-1',
		   'eu_ES'			=> 'eu_ES.ISO8859-1',
		   'eu_ES.ISO8859-1'		=> 'eu_ES.ISO8859-1',

		   'eu_ES@euro'			=> 'eu_ES.ISO8859-15',
		   'eu_ES.ISO8859-15	'	=> 'eu_ES.ISO8859-15',
		   'eu_ES.ISO8859-15@euro'	=> 'eu_ES.ISO8859-15',

		   'eu_FR'			=> 'eu_FR.ISO8859-1',
		   'eu_FR.ISO8859-1'		=> 'eu_FR.ISO8859-1',

		   'eu_FR@euro'			=> 'eu_FR.ISO8859-15',
		   'eu_FR.ISO8859-15	'	=> 'eu_FR.ISO8859-15',
		   'eu_FR.ISO8859-15@euro'	=> 'eu_FR.ISO8859-15',

		   'fi'				=> 'fi_FI.ISO8859-1',
		   'fi_FI'			=> 'fi_FI.ISO8859-1',
		   'fi_FI.ISO8859-1'		=> 'fi_FI.ISO8859-1',

		   'fi_FI@euro'			=> 'fi_FI.ISO8859-15',
		   'fi_FI.ISO8859-15'		=> 'fi_FI.ISO8859-15',
		   'fi_FI.ISO8859-15@euro'	=> 'fi_FI.ISO8859-15',

		   'fr'				=> 'fr_FR.ISO8859-1',
		   'fr_FR'			=> 'fr_FR.ISO8859-1',
		   'fr_FR.ISO8859-1'		=> 'fr_FR.ISO8859-1',

		   'fr_FR@euro'			=> 'fr_FR.ISO8859-15',
		   'fr_FR.ISO8859-15'		=> 'fr_FR.ISO8859-15',
		   'fr_FR.ISO8859-15@euro'	=> 'fr_FR.ISO8859-15',

		   'gl'				=> 'gl_ES.ISO8859-1',
		   'gl_ES'			=> 'gl_ES.ISO8859-1',
		   'gl_ES.ISO8859-1'		=> 'gl_ES.ISO8859-1',

		   'gl_ES@euro'			=> 'gl_ES.ISO8859-15',
		   'gl_ES.ISO8859-15'		=> 'gl_ES.ISO8859-15',
		   'gl_ES.ISO8859-15@euro'	=> 'gl_ES.ISO8859-15',

		   'hr'				=> 'hr_HR.ISO8859-2',
		   'hr_HR'			=> 'hr_HR.ISO8859-2',
		   'hr_HR.ISO8859-2'		=> 'hr_HR.ISO8859-2',

		   'it'				=> 'it_IT.ISO8859-1',
		   'it_IT'			=> 'it_IT.ISO8859-1',
		   'it_IT.ISO8859-1'		=> 'it_IT.ISO8859-1',

		   'it_IT@euro'			=> 'it_IT.ISO8859-15',
		   'it_IT.ISO8859-15'		=> 'it_IT.ISO8859-15',
		   'it_IT.ISO8859-15@euro'	=> 'it_IT.ISO8859-15',

		   'ja'				=> 'ja_JP.eucJP',
		   'ja_JP'			=> 'ja_JP.eucJP',
		   'ja_JP.eucJP'		=> 'ja_JP.eucJP',
		   'ja_JP.ujis'			=> 'ja_JP.eucJP',

		   'ko'				=> 'ko_KR.eucKR',
		   'ko_KR'			=> 'ko_KR.eucKR',
		   'ko_KR.eucKR'		=> 'ko_KR.eucKR',

		   'nl'				=> 'nl_NL.ISO8859-1',
		   'nl_NL'			=> 'nl_NL.ISO8859-1',
		   'nl_NL.ISO8859-1'		=> 'nl_NL.ISO8859-1',

		   'nl_NL@euro'			=> 'nl_NL.ISO8859-15',
		   'nl_NL.ISO8859-15'		=> 'nl_NL.ISO8859-15',
		   'nl_NL.ISO8859-15@euro'	=> 'nl_NL.ISO8859-15',

		   'pl'				=> 'pl_PL.ISO8859-2',
		   'pl_PL'			=> 'pl_PL.ISO8859-2',
		   'pl_PL.ISO8859-2'		=> 'pl_PL.ISO8859-2',

		   'pt'				=> 'pt_PT.ISO8859-1',
		   'pt_BR'			=> 'pt_BR.ISO8859-1',
		   'pt_BR.ISO8859-1'		=> 'pt_BR.ISO8859-1',

		   'pt_PT'			=> 'pt_PT.ISO8859-1',
		   'pt_PT.ISO8859-1'		=> 'pt_PT.ISO8859-1',

		   'pt_PT@euro'			=> 'pt_PT.ISO8859-15',
		   'pt_PT.ISO8859-15'		=> 'pt_PT.ISO8859-15',
		   'pt_PT.ISO8859-15@euro'	=> 'pt_PT.ISO8859-15',

		   'ro'				=> 'ro_RO.ISO8859-2',
		   'ro_RO'			=> 'ro_RO.ISO8859-2',
		   'ro_RO.ISO8859-2'		=> 'ro_RO.ISO8859-2',

		   'ru'				=> 'ru_RU.KOI8-R',
		   'ru_RU'			=> 'ru_RU.KOI8-R',
		   'ru_RU.KOI8-R'		=> 'ru_RU.KOI8-R',

		   'sk'				=> 'sk_SK.ISO8859-2',
		   'sk_SK'			=> 'sk_SK.ISO8859-2',
		   'sk_SK.ISO8859-2'		=> 'sk_SK.ISO8859-2',

		   'sl'                         => 'sl_SI.ISO8859-2',
		   'sl_SI'                      => 'sl_SI.ISO8859-2',
		   'sl_SI.ISO8859-2'            => 'sl_SI.ISO8859-2',

		   'tr'				=> 'tr_TR.ISO8859-9',
		   'tr_TR'			=> 'tr_TR.ISO8859-9',
		   'tr_TR.ISO8859-9'		=> 'tr_TR.ISO8859-9',

		   'zh_CN'			=> 'zh_CN.GB2312',
		   'zh_CN.GB2312'		=> 'zh_CN.GB2312',

		   'zh_HK'			=> 'zh_TW.Big5',
		   'zh_HK.Big5' 		=> 'zh_TW.Big5',

		   'zh_TW'			=> 'zh_TW.Big5',
		   'zh_TW.Big5'			=> 'zh_TW.Big5',

		   );

## ----------------------------------------------------------------------
## don't forget this
1;

## ----------------------------------------------------------------------
