/**
 * Compile NFA to DFA.
 * @author Shaun Jackman <sdj@sfu.ca>
 * @copyright Copyright 2004 Shaun Jackman
 */


#include <stdio.h>
#include "dfa.h"
#include "nfa.h"


/** Name of this program. */
const char* program = "nfac";


/** Compiles the NFA on stdin to DFA. */
int
main()
{
	NFA nfa;
	DFA dfa;
	char c;
	while( (c = getchar()) != '[')
		putchar( c);
	ungetc( c, stdin);
	read_nfa( &nfa, stdin);
	compile_nfa( &dfa, &nfa);
	print_dfa( &dfa);
	return 0;
}
