/* dia-tool.c
 * Copyright (C) 2001  Arjan Molenaar
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "dia-tool.h"
#include "dia-canvas-i18n.h"
#include "diamarshal.h"

enum {
	BUTTON_PRESS_EVENT,
	BUTTON_RELEASE_EVENT,
	MOTION_NOTIFY_EVENT,
	KEY_PRESS_EVENT,
	KEY_RELEASE_EVENT,
	LAST_SIGNAL
};

static void dia_tool_class_init	(DiaToolClass *class);
static void dia_tool_init	(DiaTool *tool);

static guint tool_signals[LAST_SIGNAL] = { 0 };

GType
dia_tool_get_type (void)
{
	static GtkType object_type = 0;

	if (!object_type) {
		static const GTypeInfo object_info = {
			sizeof (DiaToolClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) dia_tool_class_init,
			(GClassFinalizeFunc) NULL,
			(gconstpointer) NULL, /* class_data */
			sizeof (DiaTool),
			(guint16) 0, /* n_preallocs */
			(GInstanceInitFunc) dia_tool_init,
		};

		object_type = g_type_register_static (G_TYPE_OBJECT,
						      "DiaTool",
						      &object_info,
						      G_TYPE_FLAG_ABSTRACT);
	}

	return object_type;
}

static void
dia_tool_class_init (DiaToolClass *klass)
{
	klass->button_press_event = NULL;
	klass->button_release_event = NULL;
	klass->motion_notify_event = NULL;
	klass->key_press_event = NULL;
	klass->key_release_event = NULL;

	tool_signals[BUTTON_PRESS_EVENT] =
		g_signal_new ("button_press_event",
			G_TYPE_FROM_CLASS (klass),
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET (DiaToolClass, button_press_event),
			NULL, NULL,
			dia_marshal_BOOLEAN__OBJECT_BOXED,
			G_TYPE_BOOLEAN, 2,
			DIA_TYPE_CANVAS_VIEW,
			GDK_TYPE_EVENT | G_SIGNAL_TYPE_STATIC_SCOPE);
	tool_signals[BUTTON_RELEASE_EVENT] =
		g_signal_new ("button_release_event",
			G_TYPE_FROM_CLASS (klass),
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET (DiaToolClass, button_release_event),
			NULL, NULL,
			dia_marshal_BOOLEAN__OBJECT_BOXED,
			G_TYPE_BOOLEAN, 2,
			DIA_TYPE_CANVAS_VIEW,
			GDK_TYPE_EVENT | G_SIGNAL_TYPE_STATIC_SCOPE);
	tool_signals[MOTION_NOTIFY_EVENT] =
		g_signal_new ("motion_notify_event",
			G_TYPE_FROM_CLASS (klass),
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET (DiaToolClass, motion_notify_event),
			NULL, NULL,
			dia_marshal_BOOLEAN__OBJECT_BOXED,
			G_TYPE_BOOLEAN, 2,
			DIA_TYPE_CANVAS_VIEW,
			GDK_TYPE_EVENT | G_SIGNAL_TYPE_STATIC_SCOPE);
	tool_signals[KEY_PRESS_EVENT] =
		g_signal_new ("key_press_event",
			G_TYPE_FROM_CLASS (klass),
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET (DiaToolClass, key_press_event),
			NULL, NULL,
			dia_marshal_BOOLEAN__OBJECT_BOXED,
			G_TYPE_BOOLEAN, 2,
			DIA_TYPE_CANVAS_VIEW,
			GDK_TYPE_EVENT | G_SIGNAL_TYPE_STATIC_SCOPE);
	tool_signals[KEY_RELEASE_EVENT] =
		g_signal_new ("key_release_event",
			G_TYPE_FROM_CLASS (klass),
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET (DiaToolClass, key_release_event),
			NULL, NULL,
			dia_marshal_BOOLEAN__OBJECT_BOXED,
			G_TYPE_BOOLEAN, 2,
			DIA_TYPE_CANVAS_VIEW,
			GDK_TYPE_EVENT | G_SIGNAL_TYPE_STATIC_SCOPE);
}

static void
dia_tool_init (DiaTool *tool)
{
}

gboolean
dia_tool_button_press (DiaTool *tool, DiaCanvasView *view,
			GdkEventButton *event)
{
	gboolean result = FALSE;

	g_signal_emit (tool, tool_signals[BUTTON_PRESS_EVENT], 0, view, event, &result);

	return result;
}

gboolean
dia_tool_button_release (DiaTool *tool, DiaCanvasView *view,
				   GdkEventButton *event)
{
	gboolean result = FALSE;

	g_signal_emit (tool, tool_signals[BUTTON_RELEASE_EVENT], 0, view, event, &result);

	return result;
}

gboolean
dia_tool_motion_notify (DiaTool *tool, DiaCanvasView *view,
				  GdkEventMotion *event)
{
	gboolean result = FALSE;

	g_signal_emit (tool, tool_signals[MOTION_NOTIFY_EVENT], 0, view, event, &result);

	return result;
}

gboolean
dia_tool_key_press (DiaTool *tool, DiaCanvasView *view,
			      GdkEventKey *event)
{
	gboolean result = FALSE;

	g_signal_emit (tool, tool_signals[KEY_PRESS_EVENT], 0, view, event, &result);

	return result;
}

gboolean
dia_tool_key_release (DiaTool *tool, DiaCanvasView *view,
			        GdkEventKey *event)
{
	gboolean result = FALSE;

	g_signal_emit (tool, tool_signals[KEY_RELEASE_EVENT], 0,
		       view, event, &result);

	return result;
}

