/*
 * Unit tests for variables
 */

#include <diacanvas/dia-variable.h>
#include "unit-test.h"

DiaVariable *var = NULL;

gboolean is_destroyed;
gboolean changed_called;
gboolean changed_internal_called;

void
changed_cb (DiaVariable *var, gboolean *notify)
{
	*notify = TRUE;
}

void
setup (void)
{
	var = dia_variable_new ();
	g_assert (var != NULL);
	TEST_WEAK_REF (var, is_destroyed);
	g_signal_connect (var, "changed",
			  G_CALLBACK (changed_cb),
			  &changed_called);
	g_signal_connect (var, "changed_internal",
			  G_CALLBACK (changed_cb),
			  &changed_internal_called);
	is_destroyed = FALSE;
	changed_internal_called = FALSE;
	changed_called = FALSE;
}

void
teardown (void)
{
	g_object_unref (var);
	TEST (is_destroyed == TRUE)
	is_destroyed = FALSE;
	var = NULL;
}

TEST_BEGIN (DiaVariable, setup, teardown)

TEST_NEW (dia_variable_new)
{
	TEST (DIA_IS_VARIABLE (var));
	TEST (dia_variable_get_value (var) == 0.0);
	TEST (dia_variable_get_strength (var) == DIA_STRENGTH_WEAK);
}

TEST_NEW (dia_variable_set_value)
{
	dia_variable_set_value (var, 1.0);
	TEST (dia_variable_get_value (var) == 1.0);
	TEST (changed_internal_called == TRUE);
	TEST (changed_called == FALSE);

	dia_variable_set_value (var, -100.0);
	TEST (dia_variable_get_value (var) == -100.0);
}

TEST_NEW (dia_variable_set_strength)
{
	dia_variable_set_strength (var, DIA_STRENGTH_STRONG);
	TEST (dia_variable_get_strength (var) == DIA_STRENGTH_STRONG);
	TEST (changed_internal_called == FALSE);
	TEST (changed_called == FALSE);

	dia_variable_set_strength (var, DIA_STRENGTH_VERY_WEAK);
	TEST (dia_variable_get_strength (var) == DIA_STRENGTH_VERY_WEAK);
}

TEST_END ()
