/* disc.c --
 *
 * Copyright (c) 1998-2002  Mike Oliphant <oliphant@gtk.org>
 *
 *   http://www.nostatic.org/grip
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <mysql.h>
#include <glib.h>
#include <stdio.h>
#include "disc.h"
#include "mp3db.h"

gboolean LookUpDisc(MYSQL *mysql,int id,Disc *disc)
{
  MYSQL_RES *res=NULL;
  MYSQL_ROW row;
  char query[256];

  g_snprintf(query,256,"SELECT id,title,artistid,num_plays,last_play,"
	     "genre,year,gain_adjustment FROM disc where id=%d",id);

  if(mysql_query(mysql,query)||
     !(res = mysql_store_result(mysql))||
     !(row=mysql_fetch_row(res))) {
    printf("Query error\n");
    
    return TRUE;
  }

  disc->id=id;
  DBString(disc->title,row[1],80); 
  disc->artistid=DBNum(row[2]);
  disc->year=DBNum(row[6]);
  disc->gain_adjustment=DBNum(row[7]);

  mysql_free_result(res);

  return TRUE;
}

/* Take a disc idlist and make a song idlist from it */
void DiscListToSongList(MYSQL *mysql,IDList *dlist,IDList *slist)
{
  int pos;
  int num_songs;
  int tot_num_songs=0;
  char query[1024];

  /* First find out how many songs we're dealing with */
  for(pos=0;pos<dlist->num_ids;pos++) {
    g_snprintf(query,1024,"SELECT count(*) FROM song WHERE discid=%d "
	       "ORDER BY track_num",
	       dlist->ids[pos]);

    if(SingleIntQuery(mysql,query,&num_songs)) {
      tot_num_songs+=num_songs;
    }
  }

  slist->ids=g_new(int,tot_num_songs);

  slist->num_ids=0;

  /* Now grab the songs */
  for(pos=0;pos<dlist->num_ids;pos++) {
    g_snprintf(query,1024,"SELECT id FROM song WHERE discid=%d",
	       dlist->ids[pos]);

    GetListFromQuery(mysql,slist,query,FALSE);
  }

  UniqeIDList(slist);
}

/* Take a disc idlist and make an artist idlist from it */
void DiscListToArtistList(MYSQL *mysql,IDList *dlist,IDList *alist)
{
  int pos;
  char query[1024];

  alist->ids=g_new(int,dlist->num_ids);

  alist->num_ids=0;

  /* Now grab the artists */
  for(pos=0;pos<dlist->num_ids;pos++) {
    g_snprintf(query,1024,"SELECT artistid FROM disc WHERE id=%d",
	       dlist->ids[pos]);

    GetListFromQuery(mysql,alist,query,FALSE);
  }

  UniqeIDList(alist);
}
