/*****************************************************************

  mp3insert.c

  Copyright (c) 1999-2002 by Mike Oliphant - oliphant@gtk.org

    http://www.nostatic.org/grip

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.

*****************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <glib.h>
#include <string.h>
#include <mysql.h>
#include "mp3db.h"
#include "parsecfg.h"

void Usage(void);
void ParseArgs(int numargs,char *args[]);


MYSQL *mysql;
char sql_host[61]="localhost";
char sql_user[17]="ddj";
char sql_pswd[17]="";
char sql_dbname[33]="ddj_mp3";

char filename[256]="";
char artist_name[256]="";
char song_artist_name[256]="";
char disc_name[256]="";
char song_title[256]="";
char song_genre[20]="";
int song_year=0;
int track_num=-1;
int start_frame=-1;
int num_frames=-1;
char play_time[6]="";
int bpm=-1;
int gain=0;

CFGEntry cfg_entries[]={
  {"sql_host",CFG_ENTRY_STRING,61,sql_host},
  {"sql_dbname",CFG_ENTRY_STRING,33,sql_dbname},
  {"sql_user",CFG_ENTRY_STRING,17,sql_user},
  {"sql_pswd",CFG_ENTRY_STRING,17,sql_pswd},
  {"",CFG_ENTRY_LAST,0,NULL}
};

void Usage(void)
{
  printf("\nUsage: mp3insert [-options]\n\n");
  printf("  -p <path/filename>   Full path to mp3 file\n");
  printf("  -t <title>           Song title\n");
  printf("  -a <artist>          Album artist name\n");
  printf("  -i <artist>          Song artist name (if different)\n");
  printf("  -d <disc>            Disc name\n");
  printf("  -g <genre>           ID3 genre\n");
  printf("  -y <year>            Song year\n");
  printf("  -n <track>           Track number\n");
  printf("  -f <frame>           Start frame\n");
  printf("  -l <frames>          Length in frames\n");
  printf("  -m <mm:ss>           Playing time\n");
  printf("  -b <bpm>             Beats per minute\n");
  printf("  -r <dB>              Track replay gain\n");
  printf("\n\n");

  exit(-1);
}
void ParseArgs(int numargs,char *args[])
{
  int num=1;
  int pos;
  gboolean skipout;

  while(num<numargs) {
    if(*args[num]!='-') {
      printf("Bad argument: [%s]\n",args[num]);
      Usage();
    }

    for(pos=1,skipout=FALSE;args[num][pos]&&!skipout;pos++) {
      switch(args[num][pos]) {
      case 'h':
      case 'H':
      case '?':
	Usage();
	break;
      case 'p':
	strncpy(filename,args[++num],256);
	skipout=TRUE;
	break;
      case 'a':
	strncpy(artist_name,args[++num],256);
	skipout=TRUE;
	break;
      case 'i':
	strncpy(song_artist_name,args[++num],256);
	skipout=TRUE;
	break;
      case 'd':
	strncpy(disc_name,args[++num],256);
	skipout=TRUE;
	break;
      case 't':
	strncpy(song_title,args[++num],256);
	skipout=TRUE;
	break;
      case 'g':
	strncpy(song_genre,args[++num],20);
	skipout=TRUE;
	break;
      case 'y':
	song_year=atoi(args[++num]);
	skipout=TRUE;
	break;
      case 'n':
	track_num=atoi(args[++num]);
	skipout=TRUE;
	break;
      case 'f':
	start_frame=atoi(args[++num]);
	skipout=TRUE;
	break;
      case 'l':
	num_frames=atoi(args[++num]);
	skipout=TRUE;
	break;
      case 'm':
	strncpy(play_time,args[++num],6);
	skipout=TRUE;
	break;
      case 'b':
	bpm=atoi(args[++num]);
	skipout=TRUE;
	break;
      case 'r':
	gain=(int)(atof(args[++num])*100.0);
	skipout=TRUE;
	break;
      default:
	printf("Unrecognized argument [-%c]\n",args[num][1]);
	Usage();
	break;
      }
    }
    
    num++;
  }
}


int main(int argc,char *argv[])
{
  int mins=-1,secs=-1;
  char *tok;
  char buf[256];

  ParseArgs(argc,argv);  

  snprintf(buf,256,"%s/.ddj",getenv("HOME"));

  LoadConfig(buf,"DDJ",1,1,cfg_entries);

  if(!*song_title) {
    printf("Error: A song title is required\n");

    exit(-1);
  }

  if(!*artist_name) {
    printf("Error: An artist name is required\n");

    exit(-1);
  }

  tok=strtok(play_time,":");

  if(tok) {
    mins=atoi(tok);

    tok=strtok(NULL,"");

    if(tok) secs=atoi(tok);
  }

  printf("Inserting into DB: %s %s %s %s %s %s %d %d %d %d %d:%d %d\n",
	 filename,artist_name,
	 song_artist_name,
	 song_title,disc_name,song_genre,song_year,
	 track_num,start_frame,num_frames,
	 mins,secs,gain);

  mysql=ConnectSQL();

  if(!AddSQLEntry(mysql,filename,artist_name,song_artist_name,song_title,
		  disc_name,song_genre,song_year,track_num,
		  start_frame,num_frames,mins,secs,-1,gain))
    printf("Insert failed\n");

  DisconnectSQL(mysql);

  return 0;
}
