/*  $Header: /cvsroot/dvipdfmx/src/pdfdoc.h,v 1.12 2004/03/24 12:10:52 hirata Exp $

    This is dvipdfmx, an eXtended version of dvipdfm by Mark A. Wicks.

    Copyright (C) 2002 by Jin-Hwan Cho and Shunsaku Hirata,
    the dvipdfmx project team <dvipdfmx@project.ktug.or.kr>
    
    Copyright (C) 1998, 1999 by Mark A. Wicks <mwicks@kettering.edu>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
    
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
*/

#ifndef _PDFDOC_H_
#define _PDFDOC_H_

#include "pdfobj.h"
#include "pdfdev.h"

extern pdf_obj *pdf_doc_page_tree (void);
extern pdf_obj *pdf_doc_catalog   (void);
extern pdf_obj *pdf_doc_docinfo   (void);
extern pdf_obj *pdf_doc_names     (void);

extern void     pdf_doc_set_creator    (const char *creator);
extern void     pdf_doc_set_preference (const char *pref_file);

extern pdf_obj *pdf_doc_this_page     (void);
extern pdf_obj *pdf_doc_this_page_ref (void);
extern pdf_obj *pdf_doc_next_page_ref (void);
extern pdf_obj *pdf_doc_prev_page_ref (void);
extern pdf_obj *pdf_doc_ref_page      (unsigned long page_no);

extern void pdf_doc_new_page    (void);
extern void pdf_doc_finish_page (void);

extern void pdf_doc_set_mediabox (unsigned page_no, const pdf_rect *mediabox);
extern void pdf_doc_get_mediabox (unsigned page_no, pdf_rect *mediabox);

extern int  pdf_doc_add_names (const char *category, pdf_obj *key, pdf_obj *value);
extern void pdf_doc_add_annot (unsigned page_no, const pdf_rect *rect, pdf_obj *annot_dict);

extern long     pdf_doc_current_page_no (void);
extern pdf_obj *pdf_doc_current_page_resources (void);

extern void     pdf_doc_set_current_page_background (const char *str, unsigned length);

extern void     pdf_doc_add_to_page (const char *buffer, unsigned length);
extern void     pdf_doc_add_to_page_resources  (const char *category,
						const char *resource_name, pdf_obj *resources);

extern void pdf_doc_start_article (const char *name, pdf_obj *info);
extern void pdf_doc_make_article  (const char *article_id,
				   const char **bead_order, int num_beads);
extern void pdf_doc_add_bead (const char *article_id,
			      const char *bead_id,
			      long page_no, const pdf_rect *rect);

extern int  pdf_doc_bookmarks_up    (void);
extern int  pdf_doc_bookmarks_down  (void);
extern void pdf_doc_bookmarks_add   (pdf_obj *dict, int is_open);
extern int  pdf_doc_bookmarks_depth (void);

extern void pdf_doc_init (const char *filename,
			  double media_width, double media_height,
			  double annot_grow_amount, int bookmark_open_depth);
extern void pdf_doc_close (void);

extern void pdf_doc_comment (const char *comment);
     
extern void pdf_doc_set_verbose(void);

extern void pdf_doc_bop (const char *str, unsigned length);
extern void pdf_doc_eop (const char *str, unsigned length);

extern void pdf_doc_make_xform (pdf_obj     *xform,
				pdf_rect    *bbox,   /* const */
				pdf_tmatrix *matrix, /* const */
				pdf_obj     *resources_ref); /* const */

extern void     pdf_doc_current_form_info (char **ident, pdf_rect *cropbox);

extern void     pdf_doc_start_grabbing (char *ident,
					double ref_x, double ref_y, pdf_rect *cropbox);
extern pdf_obj *pdf_doc_end_grabbing   (void);

extern void pdf_doc_begin_annot (pdf_obj *dict);
extern void pdf_doc_set_box (void);
extern void pdf_doc_end_annot (void);
extern void pdf_doc_flush_annot (void);
extern void pdf_doc_expand_box (double llx, double lly, double urx, double ury);

#endif /* _PDFDOC_H_ */
