(* This file is part of EdiTeX, an editor of mathematical
 * expressions based on TeX syntax.
 * 
 * Copyright (C) 2002-2003 Luca Padovani <lpadovan@cs.unibo.it>,
 *                    2003 Paolo Marinelli <pmarinel@cs.unibo.it>.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * For more information, please visit the project's home page
 * http://helm.cs.unibo.it/editex/
 * or send an email to <lpadovan@cs.unibo.it>
 *)

type t

external get_default_dictionary_path : unit -> string
  = "ml_mathml_editor_get_default_dictionary_path"

external get_default_mathml_stylesheet_path : unit -> string
  = "ml_mathml_editor_get_default_mathml_stylesheet_path"

external get_default_tex_stylesheet_path : unit -> string
  = "ml_mathml_editor_get_default_tex_stylesheet_path"

external raw_create : 
  alt_lexer:bool ->
  dictionary_uri: string ->
  mml_uri: string -> 
  tml_uri: string ->
  log:(int -> string -> unit) ->
  t
  = "ml_mathml_editor_new"
let create ?(alt_lexer=false) = raw_create ~alt_lexer

external freeze : editor:t -> bool
  = "ml_mathml_editor_freeze"

external thaw : editor:t -> bool
  = "ml_mathml_editor_thaw"

external reset : editor:t -> unit
  = "ml_mathml_editor_reset"

external push : editor:t -> ch:char -> unit
  = "ml_mathml_editor_push"

external drop : editor:t -> alt:bool -> unit
  = "ml_mathml_editor_drop"

external cursor_hide : editor:t -> unit
  = "ml_mathml_editor_cursor_hide"

external cursor_show : editor:t -> unit
  = "ml_mathml_editor_cursor_show"

external get_tex : editor:t -> string
  = "ml_mathml_editor_get_tex"

external get_tml : editor:t -> TDocument.t
  = "ml_mathml_editor_get_tml"

external get_mml : editor:t -> TDocument.t
  = "ml_mathml_editor_get_mml"

