/* This file is part of EdiTeX, an editor of mathematical
 * expressions based on TeX syntax.
 * 
 * Copyright (C) 2002-2003 Luca Padovani <lpadovan@cs.unibo.it>,
 *                    2003 Paolo Marinelli <pmarinel@cs.unibo.it>.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * For more information, please visit the project's home page
 * http://helm.cs.unibo.it/editex/
 * or send an email to <lpadovan@cs.unibo.it>
 */

#ifndef __AMathMLFactory_hh__
#define __AMathMLFactory_hh__

#include "dom.hh"

class AMathMLFactory
{
public:
  AMathMLFactory(class ALogger& l) : logger(l) { };
  virtual ~AMathMLFactory() { };

  static std::string getDefaultMathMLStylesheetPath(void);
  static std::string getDefaultTeXStylesheetPath(void);

  virtual void documentModified(class TDocument&) = 0;
  virtual DOM::Document document(void) const = 0;

protected:
  class ALogger& logger;
};

#endif // __AMathMLFactory_hh__
