
#include <list>
#include <string>

#include "ALogger.hh"
#include "TToken.hh"
#include "ILPushLexer.hh"
#include "APushParser.hh"
#include "TDictionary.hh"

ILPushLexer::ILPushLexer(ALogger& l, APushParser& p, TDictionary& d) : LPushLexer(l, p), dictionary(d)
{
  state = ACCEPT;
}

bool
ILPushLexer::complete()
{
  if (state == MACRO)
    {
      std::list<std::string> complete_list;
      std::string new_buffer = dictionary.complete(buffer, complete_list);

      if (!complete_list.size())
        {
          // no matching macro
          logger.warning("no known macro with `" + buffer + "' prefix");
        }
      else if (complete_list.size() == 1)
        {
          // good! we have found the macro
          buffer = new_buffer;
        }
      else
        {
          // we have more than one matching macro
          logger.warning("ambiguous prefix `" + buffer + "'");
	  for (std::list<std::string>::const_iterator p = complete_list.begin();
	       p != complete_list.end();
	       p++)
	    {
	      logger.info("Candidate: " + *p);
	    }
          buffer = new_buffer;
        }

      displayCursor();
      return true;
    }
  else return false;
}
