
#ifndef _PatternLIST_H
#define _PatternLIST_H

/* include header file defining Pattern if ptg_chk is set: */
#define EMPTYptg_chkHDR
#ifndef EMPTYHDR
#include "ptg_chk.h"
#endif
#undef EMPTYptg_chkHDR

#include "PatternFunctionTypes.h"

typedef struct _PatternLE *PatternList;
typedef PatternList    *PatternListPtr;

struct _PatternLE {
Pattern         head;
PatternList     tail;
};

#define NULLPatternList         ((PatternList)0)
#define NullPatternList()       ((PatternList)0)
#define SinglePatternList(e)    (ConsPatternList((e),NULLPatternList))

#if defined(__STDC__) || defined(__cplusplus)

extern void FinlPatternList(void);
   /* Deallocates all PatternLists. */
   /* Dynamic storage is allocated on first need */

extern PatternList ConsPatternList (Pattern e, PatternList l);
   /* Constructs a PatternList of an element e and a given tail l.
    * e is the first element of the list. */

extern Pattern HeadPatternList (PatternList l);
   /* Returns the first element of the list l.
    * The list l must not be empty. */

extern PatternList TailPatternList (PatternList l);
   /* Returns the tail of the list l.
    * If l is empty, an empty list is returned. */

extern int LengthPatternList (PatternList l);
   /* Returns the number of elements in the list l. */

extern Pattern IthElemPatternList (PatternList l, int i);
   /* Returns the i-th element of the List l. The head of l
    * is referred to as 1. If the value of
    * i is greater than the length of the list, an error
    * is reported and the program exits.
    */

extern PatternList CopyPatternList (PatternList l, PatternMapFct cp);
   /* Copies the list l. Elements are copied by calls of cp. */

extern PatternList AppPatternList (PatternList l1, PatternList l2);
   /* Concatenates two lists l1 and l2. The resulting list contains l2 at
    * the end of a copy of list l1. */

extern PatternList AppElPatternList (PatternList l, Pattern e);
   /* Appends an element e to the list l.
    * The list l is not copied, it is modified as a side-effect
    * of this function. */

extern void InsertAfterPatternList (PatternList l, Pattern e);
   /* This function requires a non-empty list l. The element e is inserted
    * just after the first element of l. 
    * The list l is modified as a side-effect of this function. */

extern PatternList OrderedInsertPatternList (PatternList l, Pattern e, PatternCmpFctType fcmp);
   /* Inserts the element e into the list l maintaining l in
    * ascending order with respect to the compare fcmp. 
    * The list l is modified as a side-effect of this function. */

extern PatternListPtr RefEndConsPatternList (PatternListPtr addr, Pattern e);
   /* Appends an element e to the end of a list given by its address addr.
    * The address where the next element may be appended is returned.
    * The list is modified as a side-effect of this function. */

extern PatternListPtr RefEndAppPatternList (PatternListPtr addr, PatternList l);
   /* Appends a list l to the end of a list given by its address addr.
    * The address where the next element may be appended is returned.
    * The list is modified as a side-effect of this function. */

extern int ElemInPatternList (Pattern e, PatternList l, PatternCmpFctType cmpfct);
   /* This function returns true (1) iff the element e is in the List l.
    * List elements are compared by the function cmpfct. */

extern PatternList AddToSetPatternList (Pattern e, PatternList l, PatternCmpFctType cmpfct);
   /* A list is returned that has e as an element.
    * l is checked whether it already contains e using the compare
    * function cmpfct. */

extern PatternList AddToOrderedSetPatternList 
       (Pattern e, PatternList l, PatternCmpFctType cmpfct);
   /* A list is returned that has e as an element.
    * l is checked whether it already contains e using the compare
    * function cmpfct. l is assumed to be ordered increasingly in the sense of
    * cmpfct. */

extern PatternList MapPatternList (PatternList l, PatternMapFct f);
   /* Returns a new PatternList obtained by applying f to each element of l. */

extern int CompPatternList (PatternList l1, PatternList l2, PatternCmpFctType f);
   /* Compares the lists l1 and l2 lexicographically by applying f
    * to the corresponding elements. */

extern Pattern SumPatternList (PatternList l, PatternSumFct f, Pattern a);
   /* Applies the binary function f to the elements of the List:
    *   f( f(... f(a, e1), e2, ...), en)
    * If l is empty a is returned. */

#else

extern void FinlPatternList ();
extern PatternList ConsPatternList ();
extern Pattern HeadPatternList ();
extern PatternList TailPatternList ();
extern int LengthPatternList ();
extern Pattern IthElemPatternList ();
extern PatternList CopyPatternList ();
extern PatternList AppPatternList ();
extern PatternList AppElPatternList ();
extern void InsertAfterPatternList ();
extern PatternList OrderedInsertPatternList ();
extern PatternListPtr RefEndConsPatternList ();
extern PatternListPtr RefEndAppPatternList ();
extern int ElemInPatternList ();
extern PatternList AddToSetPatternList ();
extern PatternList MapPatternList ();
extern int CompPatternList ();
extern Pattern SumPatternList ();

#endif

#ifdef MONITOR
#define DAPTO_RESULTPatternList(l) DAPTO_RESULT_PTR(l)
#define DAPTO_ARGPatternList(l)    DAPTO_ARG_PTR (l, PatternList)
#endif

#endif
