/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *  Author: Stéphane Démurget  <stephane.demurget@enst-bretagne.fr>
 */

#ifndef __EMIFREQ_H__
#define __EMIFREQ_H__

#include <gnome.h>
#include <panel-applet.h>

#include "ef-msg-queue.h"
#include "ef-backend.h"

typedef struct
{
	PanelApplet base;

	GtkWidget *box, *icon, *label;
	GtkWidget *popup;
	GtkDialog *prefs, *about;
	GtkTooltips *tooltips;

	EFMessageQueue *msg_queue;

	int label_width, label_height;
	guint timeout_id;
	gboolean horizontal;
	gulong handler_id;
	gboolean popup_dirty;
	EFBackendGovernors last_avail_governors;

	/* preferences */
	guint32 refresh_time;
	gboolean enable_metric;
	gboolean show_temp;
	gboolean read_only;
} EmiFreqApplet;

GdkPixbuf *get_pixbuf_from_usage (EmiFreqApplet *applet, float usage);
void	   reset_timeout 	 (EmiFreqApplet *applet);
void	   force_refresh 	 (EmiFreqApplet *applet, gboolean only_icon);

#endif
